/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty.specifier;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.specifier.Condition;
import org.opentripplanner.osm.wayproperty.specifier.OsmSpecifier;

public class ExactMatchSpecifier
implements OsmSpecifier {
    public static final int MATCH_MULTIPLIER = 200;
    public static final int NO_MATCH_SCORE = 0;
    private final List<Condition> conditions;
    private final int bestMatchScore;

    public ExactMatchSpecifier(String spec) {
        this(OsmSpecifier.parseConditions(spec, ";"));
    }

    public ExactMatchSpecifier(Condition ... conditions) {
        this.conditions = Arrays.asList(conditions);
        this.bestMatchScore = this.conditions.size() * 200;
    }

    @Override
    public int matchScore(OsmEntity way, TraverseDirection direction) {
        return this.allTagsMatch(way, direction) ? this.bestMatchScore : 0;
    }

    @Override
    public String toDocString() {
        return this.conditions.stream().map(Object::toString).collect(Collectors.joining("; "));
    }

    public boolean allTagsMatch(OsmEntity way) {
        return this.conditions.stream().allMatch(o -> o.isMatch(way));
    }

    public boolean allBackwardTagsMatch(OsmEntity way) {
        return this.conditions.stream().allMatch(c -> c.isBackwardMatch(way));
    }

    public boolean allForwardTagsMatch(OsmEntity way) {
        return this.conditions.stream().allMatch(c -> c.isForwardMatch(way));
    }

    private boolean allTagsMatch(OsmEntity way, TraverseDirection direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case TraverseDirection.DIRECTIONLESS -> this.allTagsMatch(way);
            case TraverseDirection.FORWARD -> this.allForwardTagsMatch(way);
            case TraverseDirection.BACKWARD -> this.allBackwardTagsMatch(way);
        };
    }

    public static ExactMatchSpecifier exact(String spec) {
        return new ExactMatchSpecifier(spec);
    }
}

