/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty.specifier;

import java.util.Arrays;
import java.util.OptionalInt;
import org.opentripplanner.osm.model.OsmEntity;

public sealed interface Condition {
    public String key();

    default public MatchResult matchType() {
        return MatchResult.EXACT;
    }

    public boolean isExtendedKeyMatch(OsmEntity var1, String var2);

    default public boolean isMatch(OsmEntity way) {
        return this.isExtendedKeyMatch(way, this.key());
    }

    default public MatchResult match(OsmEntity way) {
        return this.isMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    default public boolean isLeftMatch(OsmEntity way) {
        String leftKey = this.key() + ":left";
        if (way.hasTag(leftKey)) {
            return this.isExtendedKeyMatch(way, leftKey);
        }
        return this.isExplicitBothMatch(way);
    }

    default public boolean isRightMatch(OsmEntity way) {
        String rightKey = this.key() + ":right";
        if (way.hasTag(rightKey)) {
            return this.isExtendedKeyMatch(way, rightKey);
        }
        return this.isExplicitBothMatch(way);
    }

    default public boolean isExplicitBothMatch(OsmEntity way) {
        String bothKey = this.key() + ":both";
        if (way.hasTag(bothKey)) {
            return this.isExtendedKeyMatch(way, bothKey);
        }
        return this.isMatch(way);
    }

    default public boolean isForwardMatch(OsmEntity way) {
        String forwardKey = this.key() + ":forward";
        if (way.hasTag(forwardKey)) {
            return this.isExtendedKeyMatch(way, forwardKey);
        }
        return this.isRightMatch(way);
    }

    default public MatchResult matchForward(OsmEntity way) {
        return this.isForwardMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    default public boolean isBackwardMatch(OsmEntity way) {
        String backwardKey = this.key() + ":backward";
        if (way.hasTag(backwardKey)) {
            return this.isExtendedKeyMatch(way, backwardKey);
        }
        return this.isLeftMatch(way);
    }

    default public MatchResult matchBackward(OsmEntity way) {
        return this.isBackwardMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    public static enum MatchResult {
        EXACT,
        WILDCARD,
        NONE;

    }

    public record OneOfOrAbsent(String key, String[] values) implements Condition
    {
        public OneOfOrAbsent(String key) {
            this(key, "no", "none");
        }

        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            return !way.hasTag(exKey) || Arrays.stream(this.values).anyMatch(value -> way.isTag(exKey, (String)value));
        }

        @Override
        public String toString() {
            return "%s not one of [%s] or absent".formatted(this.key, String.join((CharSequence)", ", this.values));
        }
    }

    public record OneOf(String key, String[] values) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            return Arrays.stream(this.values).anyMatch(value -> way.isTag(exKey, (String)value));
        }

        @Override
        public String toString() {
            return "%s one of [%s]".formatted(this.key, String.join((CharSequence)", ", this.values));
        }
    }

    public record InclusiveRange(String key, int upper, int lower) implements Condition
    {
        public InclusiveRange {
            if (upper < lower) {
                throw new IllegalArgumentException("Upper bound is lower than lower bound");
            }
        }

        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() >= this.lower && maybeInt.getAsInt() <= this.upper;
        }

        @Override
        public String toString() {
            return "%s > %s < %s".formatted(this.lower, this.key, this.upper);
        }
    }

    public record LessThan(String key, int value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() < this.value;
        }

        @Override
        public String toString() {
            return "%s < %s".formatted(this.key, this.value);
        }
    }

    public record GreaterThan(String key, int value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() > this.value;
        }

        @Override
        public String toString() {
            return "%s > %s".formatted(this.key, this.value);
        }
    }

    public record Absent(String key) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            return !way.hasTag(exKey);
        }

        @Override
        public String toString() {
            return "!%s".formatted(this.key);
        }
    }

    public record Present(String key) implements Condition
    {
        @Override
        public MatchResult matchType() {
            return MatchResult.WILDCARD;
        }

        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            return way.hasTag(exKey);
        }

        @Override
        public String toString() {
            return "present(%s)".formatted(this.key);
        }
    }

    public record Equals(String key, String value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OsmEntity way, String exKey) {
            return way.hasTag(exKey) && way.isTag(exKey, this.value);
        }

        @Override
        public String toString() {
            return "%s=%s".formatted(this.key, this.value);
        }
    }
}

