/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty.specifier;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.specifier.Condition;
import org.opentripplanner.osm.wayproperty.specifier.OsmSpecifier;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class BestMatchSpecifier
implements OsmSpecifier {
    public static final int EXACT_MATCH_SCORE = 100;
    public static final int WILDCARD_MATCH_SCORE = 1;
    public static final int NO_MATCH_SCORE = 0;
    private final Condition[] conditions;

    @Deprecated
    public BestMatchSpecifier(String spec) {
        this.conditions = OsmSpecifier.parseConditions(spec, ";");
    }

    @Override
    public int matchScore(OsmEntity way, TraverseDirection direction) {
        int score = 0;
        int matches = 0;
        for (Condition test : this.conditions) {
            Condition.MatchResult match = switch (direction) {
                default -> throw new MatchException(null, null);
                case TraverseDirection.DIRECTIONLESS -> test.match(way);
                case TraverseDirection.FORWARD -> test.matchForward(way);
                case TraverseDirection.BACKWARD -> test.matchBackward(way);
            };
            int tagScore = BestMatchSpecifier.toTagScore(match);
            score += tagScore;
            if (tagScore <= 0) continue;
            ++matches;
        }
        int allMatchBonus = matches == this.conditions.length ? 10 : 0;
        return score += allMatchBonus;
    }

    @Override
    public String toDocString() {
        return Arrays.stream(this.conditions).map(Object::toString).collect(Collectors.joining("; "));
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("conditions", (Object)this.conditions).toString();
    }

    private static int toTagScore(Condition.MatchResult res) {
        return switch (res) {
            default -> throw new MatchException(null, null);
            case Condition.MatchResult.EXACT -> 100;
            case Condition.MatchResult.WILDCARD -> 1;
            case Condition.MatchResult.NONE -> 0;
        };
    }
}

