/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.functional.FunctionUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.CreativeNamer;
import org.opentripplanner.osm.wayproperty.CreativeNamerPicker;
import org.opentripplanner.osm.wayproperty.MixinDirectionalProperties;
import org.opentripplanner.osm.wayproperty.MixinProperties;
import org.opentripplanner.osm.wayproperty.MixinPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.NotePicker;
import org.opentripplanner.osm.wayproperty.NoteProperties;
import org.opentripplanner.osm.wayproperty.SlopeOverridePicker;
import org.opentripplanner.osm.wayproperty.SpeedPicker;
import org.opentripplanner.osm.wayproperty.WayProperties;
import org.opentripplanner.osm.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.WayPropertiesPair;
import org.opentripplanner.osm.wayproperty.WayPropertyPicker;
import org.opentripplanner.osm.wayproperty.specifier.BestMatchSpecifier;
import org.opentripplanner.osm.wayproperty.specifier.OsmSpecifier;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.note.StreetNoteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayPropertySet {
    private static final Logger LOG = LoggerFactory.getLogger(WayPropertySet.class);
    private final FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> DEFAULT_SAFETY_RESOLVER = (permission, speedLimit, osmWay) -> 1.0;
    private final List<WayPropertyPicker> wayProperties;
    private final List<CreativeNamerPicker> creativeNamers;
    private final List<SlopeOverridePicker> slopeOverrides;
    private final List<SpeedPicker> speedPickers;
    private final List<NotePicker> notes;
    private final Pattern maxSpeedPattern;
    public Float defaultCarSpeed;
    public Float maxPossibleCarSpeed;
    public float maxUsedCarSpeed = 0.0f;
    private FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> defaultWalkSafetyForPermission;
    private FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> defaultBicycleSafetyForPermission;
    private final WayProperties defaultProperties;
    private final DataImportIssueStore issueStore;
    private final List<MixinProperties> mixins = new ArrayList<MixinProperties>();

    public List<MixinProperties> getMixins() {
        return this.mixins;
    }

    public WayPropertySet() {
        this(DataImportIssueStore.NOOP);
    }

    public WayPropertySet(DataImportIssueStore issueStore) {
        this.defaultCarSpeed = Float.valueOf(11.2f);
        this.maxPossibleCarSpeed = Float.valueOf(38.0f);
        this.defaultProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).build();
        this.wayProperties = new ArrayList<WayPropertyPicker>();
        this.creativeNamers = new ArrayList<CreativeNamerPicker>();
        this.slopeOverrides = new ArrayList<SlopeOverridePicker>();
        this.speedPickers = new ArrayList<SpeedPicker>();
        this.notes = new ArrayList<NotePicker>();
        this.maxSpeedPattern = Pattern.compile("^([0-9][.0-9]*)\\s*(kmh|km/h|kmph|kph|mph|knots)?$");
        this.defaultWalkSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
        this.defaultBicycleSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
        this.issueStore = issueStore;
    }

    public WayPropertiesPair getDataForWay(OsmWay way) {
        return new WayPropertiesPair(this.getDataForEntity(way, TraverseDirection.FORWARD), this.getDataForEntity(way, TraverseDirection.BACKWARD));
    }

    public WayProperties getDataForEntity(OsmEntity entity) {
        return this.getDataForEntity(entity, TraverseDirection.DIRECTIONLESS);
    }

    public WayProperties getDataForEntity(OsmEntity entity, TraverseDirection direction) {
        WayProperties result = this.defaultProperties;
        int bestScore = 0;
        ArrayList<MixinProperties> matchedMixins = new ArrayList<MixinProperties>();
        for (WayPropertyPicker picker : this.wayProperties) {
            int score;
            WayProperties wayProperties;
            OsmSpecifier specifier = picker.specifier();
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case DIRECTIONLESS: {
                    WayProperties wayProperties2 = picker.properties();
                    break;
                }
                case FORWARD: {
                    WayProperties wayProperties2 = picker.forwardProperties();
                    break;
                }
                case BACKWARD: {
                    WayProperties wayProperties2 = wayProperties = picker.backwardProperties();
                }
            }
            if ((score = specifier.matchScore(entity, direction)) <= bestScore) continue;
            result = wayProperties;
            bestScore = score;
        }
        for (MixinProperties mixin : this.mixins) {
            int score = mixin.specifier().matchScore(entity, direction);
            if (score <= 0) continue;
            matchedMixins.add(mixin);
        }
        float speed = this.getCarSpeedForWay(entity, TraverseDirection.DIRECTIONLESS);
        StreetTraversalPermission permission = entity.overridePermissions(result.getPermission(), direction);
        result = result.mutate().withPermission(permission).bicycleSafety(result.bicycleSafetyOpt().orElseGet(() -> this.defaultBicycleSafetyForPermission.apply(permission, Float.valueOf(speed), entity))).walkSafety(result.walkSafetyOpt().orElseGet(() -> this.defaultWalkSafetyForPermission.apply(permission, Float.valueOf(speed), entity))).build();
        if (!matchedMixins.isEmpty()) {
            result = this.applyMixins(result, matchedMixins, direction);
        }
        if (bestScore == 0 && matchedMixins.isEmpty()) {
            String allTags = this.dumpTags(entity);
            LOG.debug("Used default permissions: {}", (Object)allTags);
        }
        return result;
    }

    public I18NString getCreativeNameForWay(OsmEntity way) {
        CreativeNamer bestNamer = null;
        int bestScore = 0;
        for (CreativeNamerPicker picker : this.creativeNamers) {
            OsmSpecifier specifier = picker.specifier;
            CreativeNamer namer = picker.namer;
            int score = specifier.matchScore(way, TraverseDirection.DIRECTIONLESS);
            if (score <= bestScore) continue;
            bestNamer = namer;
            bestScore = score;
        }
        if (bestNamer == null) {
            return null;
        }
        return bestNamer.generateCreativeName(way);
    }

    public float getCarSpeedForWay(OsmEntity way, TraverseDirection direction) {
        Float speed = null;
        if (way.hasTag("maxspeed:motorcar")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:motorcar"));
        }
        if (speed == null && direction == TraverseDirection.FORWARD && way.hasTag("maxspeed:forward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:forward"));
        }
        if (speed == null && direction == TraverseDirection.BACKWARD && way.hasTag("maxspeed:backward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:backward"));
        }
        if (speed == null && way.hasTag("maxspeed:lanes")) {
            for (String lane : way.getTag("maxspeed:lanes").split("\\|")) {
                Float currentSpeed = this.getMetersSecondFromSpeed(lane);
                if (currentSpeed == null || speed != null && !(currentSpeed.floatValue() > speed.floatValue())) continue;
                speed = currentSpeed;
            }
        }
        if (way.hasTag("maxspeed") && speed == null) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed"));
        }
        if (speed != null) {
            if ((double)speed.floatValue() < 1.387 || (double)speed.floatValue() > (double)this.maxPossibleCarSpeed.floatValue() + 1.0E-4) {
                long id = way.getId();
                String link = way.url();
                this.issueStore.add("InvalidCarSpeedLimit", "OSM object with id '%s' (%s) has an invalid maxspeed value (%f), that speed will be ignored", id, link, speed);
            } else {
                if (speed.floatValue() > this.maxUsedCarSpeed) {
                    this.maxUsedCarSpeed = speed.floatValue();
                }
                return speed.floatValue();
            }
        }
        int bestScore = 0;
        Float bestSpeed = null;
        for (SpeedPicker picker : this.speedPickers) {
            OsmSpecifier specifier = picker.specifier;
            int score = specifier.matchScore(way, direction);
            if (score <= bestScore) continue;
            bestScore = score;
            bestSpeed = Float.valueOf(picker.speed);
        }
        if (bestSpeed != null) {
            if (bestSpeed.floatValue() > this.maxUsedCarSpeed) {
                this.maxUsedCarSpeed = bestSpeed.floatValue();
            }
            return bestSpeed.floatValue();
        }
        return this.defaultCarSpeed.floatValue();
    }

    public Set<StreetNoteAndMatcher> getNoteForWay(OsmEntity way) {
        HashSet<StreetNoteAndMatcher> out = new HashSet<StreetNoteAndMatcher>();
        for (NotePicker picker : this.notes) {
            OsmSpecifier specifier = picker.specifier;
            NoteProperties noteProperties = picker.noteProperties;
            if (specifier.matchScore(way, TraverseDirection.DIRECTIONLESS) <= 0) continue;
            out.add(noteProperties.generateNote(way));
        }
        return out;
    }

    public boolean getSlopeOverride(OsmEntity way) {
        boolean result = false;
        int bestScore = 0;
        for (SlopeOverridePicker picker : this.slopeOverrides) {
            OsmSpecifier specifier = picker.getSpecifier();
            int score = specifier.matchScore(way, TraverseDirection.DIRECTIONLESS);
            if (score <= bestScore) continue;
            result = picker.getOverride();
            bestScore = score;
        }
        return result;
    }

    public void addMixin(MixinProperties mixin) {
        this.mixins.add(mixin);
    }

    public void addProperties(OsmSpecifier spec, WayProperties properties) {
        this.addProperties(spec, properties, properties, properties);
    }

    public void addProperties(OsmSpecifier spec, WayProperties properties, WayProperties forwardProperties, WayProperties backwardProperties) {
        this.wayProperties.add(new WayPropertyPicker(spec, properties, forwardProperties, backwardProperties));
    }

    public void addCreativeNamer(OsmSpecifier spec, CreativeNamer namer) {
        this.creativeNamers.add(new CreativeNamerPicker(spec, namer));
    }

    public void addNote(OsmSpecifier osmSpecifier, NoteProperties properties) {
        this.notes.add(new NotePicker(osmSpecifier, properties));
    }

    public void setSlopeOverride(OsmSpecifier spec, boolean override) {
        this.slopeOverrides.add(new SlopeOverridePicker(spec, override));
    }

    public int hashCode() {
        return this.defaultProperties.hashCode() + this.wayProperties.hashCode() + this.creativeNamers.hashCode() + this.slopeOverrides.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WayPropertySet) {
            WayPropertySet other = (WayPropertySet)o;
            return this.defaultProperties.equals(other.defaultProperties) && this.wayProperties.equals(other.wayProperties) && this.creativeNamers.equals(other.creativeNamers) && this.slopeOverrides.equals(other.slopeOverrides) && this.notes.equals(other.notes);
        }
        return false;
    }

    public void addSpeedPicker(SpeedPicker picker) {
        this.speedPickers.add(picker);
    }

    public Float getMetersSecondFromSpeed(String speed) {
        float metersSecond;
        float originalUnits;
        Matcher m = this.maxSpeedPattern.matcher(speed.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            originalUnits = (float)Double.parseDouble(m.group(1));
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse max speed {}", (Object)m.group(1));
            return null;
        }
        String units = m.group(2);
        if (units == null || units.isEmpty()) {
            units = "kmh";
        }
        switch (units = units.intern()) {
            case "kmh": 
            case "km/h": 
            case "kmph": 
            case "kph": {
                metersSecond = 0.277778f * originalUnits;
                break;
            }
            case "mph": {
                metersSecond = 0.446944f * originalUnits;
                break;
            }
            case "knots": {
                metersSecond = 0.514444f * originalUnits;
                break;
            }
            default: {
                return null;
            }
        }
        return Float.valueOf(metersSecond);
    }

    public void createNames(String spec, String patternKey) {
        CreativeNamer namer = new CreativeNamer(patternKey);
        this.addCreativeNamer(new BestMatchSpecifier(spec), namer);
    }

    public void createNotes(String spec, String patternKey, StreetNoteMatcher matcher) {
        NoteProperties properties = new NoteProperties(patternKey, matcher);
        this.addNote(new BestMatchSpecifier(spec), properties);
    }

    public void setDefaultWalkSafetyForPermission(FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> defaultWalkSafetyForPermission) {
        if (!this.defaultWalkSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default walk safety resolver was already set");
        }
        this.defaultWalkSafetyForPermission = defaultWalkSafetyForPermission;
    }

    public void setDefaultBicycleSafetyForPermission(FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> defaultBicycleSafetyForPermission) {
        if (!this.defaultBicycleSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default cycling safety resolver was already set");
        }
        this.defaultBicycleSafetyForPermission = defaultBicycleSafetyForPermission;
    }

    public void setMixinProperties(OsmSpecifier spec, MixinPropertiesBuilder builder) {
        this.addMixin(builder.build(spec));
    }

    public void setMixinProperties(String spec, MixinPropertiesBuilder builder) {
        this.setMixinProperties(new BestMatchSpecifier(spec), builder);
    }

    public void setProperties(String s, WayProperties props) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(s), props);
    }

    public void setProperties(String spec, WayPropertiesBuilder properties) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(spec), properties);
    }

    public void setProperties(String spec, WayPropertiesBuilder properties, WayPropertiesBuilder forwardProperties, WayPropertiesBuilder backwardProperties) {
        this.setProperties(new BestMatchSpecifier(spec), properties, forwardProperties, backwardProperties);
    }

    public void setProperties(OsmSpecifier spec, WayProperties properties) {
        this.addProperties(spec, properties);
    }

    public void setProperties(OsmSpecifier spec, WayPropertiesBuilder properties) {
        this.addProperties(spec, properties.build());
    }

    public void setProperties(OsmSpecifier spec, WayPropertiesBuilder properties, WayPropertiesBuilder forwardProperties, WayPropertiesBuilder backwardProperties) {
        this.addProperties(spec, properties.build(), forwardProperties.build(), backwardProperties.build());
    }

    public void setCarSpeed(String spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = new BestMatchSpecifier(spec);
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public void setCarSpeed(OsmSpecifier spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = spec;
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public List<WayPropertyPicker> getWayProperties() {
        return Collections.unmodifiableList(this.wayProperties);
    }

    private String dumpTags(OsmEntity way) {
        String all_tags = null;
        Map<String, String> tags = way.getTags();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String tag = key + "=" + value;
            if (all_tags == null) {
                all_tags = tag;
                continue;
            }
            all_tags = all_tags + "; " + tag;
        }
        return all_tags;
    }

    private WayProperties applyMixins(WayProperties result, List<MixinProperties> mixins, TraverseDirection direction) {
        double bicycle = result.bicycleSafety();
        double walk = result.walkSafety();
        for (MixinProperties mixin : mixins) {
            MixinDirectionalProperties properties = mixin.getDirectionalProperties(direction);
            bicycle *= properties.bicycleSafety();
            walk *= properties.walkSafety();
        }
        return result.mutate().bicycleSafety(bicycle).walkSafety(walk).build();
    }
}

