/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty;

import javax.annotation.Nullable;
import org.opentripplanner.osm.wayproperty.WayProperties;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class WayPropertiesBuilder {
    private StreetTraversalPermission permission;
    private Double bicycleSafetyFeatures = null;
    private Double walkSafetyFeatures = null;

    public WayPropertiesBuilder(StreetTraversalPermission permission) {
        this.permission = permission;
    }

    WayPropertiesBuilder(WayProperties defaultProperties) {
        this.permission = defaultProperties.getPermission();
        this.bicycleSafetyFeatures = defaultProperties.bicycleSafety();
        this.walkSafetyFeatures = defaultProperties.walkSafety();
    }

    public WayPropertiesBuilder bicycleSafety(double bicycleSafety) {
        this.bicycleSafetyFeatures = bicycleSafety;
        return this;
    }

    public WayPropertiesBuilder walkSafety(double walkSafety) {
        this.walkSafetyFeatures = walkSafety;
        return this;
    }

    public WayPropertiesBuilder withPermission(StreetTraversalPermission permission) {
        this.permission = permission;
        return this;
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    @Nullable
    protected Double bicycleSafety() {
        return this.bicycleSafetyFeatures;
    }

    @Nullable
    protected Double walkSafety() {
        return this.walkSafetyFeatures;
    }

    public WayProperties build() {
        return new WayProperties(this);
    }

    public static WayPropertiesBuilder withModes(StreetTraversalPermission p) {
        return new WayPropertiesBuilder(p);
    }
}

