/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty;

import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import org.opentripplanner.osm.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class WayProperties {
    private final StreetTraversalPermission permission;
    @Nullable
    private final Double bicycleSafety;
    @Nullable
    private final Double walkSafety;

    WayProperties(WayPropertiesBuilder wayPropertiesBuilder) {
        this.permission = Objects.requireNonNull(wayPropertiesBuilder.getPermission());
        this.bicycleSafety = wayPropertiesBuilder.bicycleSafety();
        this.walkSafety = wayPropertiesBuilder.walkSafety();
    }

    public double bicycleSafety() {
        return Objects.requireNonNullElse(this.bicycleSafety, 1.0);
    }

    public double walkSafety() {
        return Objects.requireNonNullElse(this.walkSafety, 1.0);
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    protected OptionalDouble walkSafetyOpt() {
        return this.walkSafety == null ? OptionalDouble.empty() : OptionalDouble.of(this.walkSafety);
    }

    protected OptionalDouble bicycleSafetyOpt() {
        return this.bicycleSafety == null ? OptionalDouble.empty() : OptionalDouble.of(this.bicycleSafety);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bicycleSafety, this.walkSafety, this.permission});
    }

    public boolean equals(Object o) {
        if (o instanceof WayProperties) {
            WayProperties other = (WayProperties)o;
            return Objects.equals(this.bicycleSafety, other.bicycleSafety) && Objects.equals(this.walkSafety, other.walkSafety) && this.permission == other.permission;
        }
        return false;
    }

    public WayPropertiesBuilder mutate() {
        return new WayPropertiesBuilder(this);
    }
}

