/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.wayproperty;

import java.util.Map;
import java.util.regex.Pattern;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.wayproperty.LocalizedStringMapper;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.note.StreetNoteMatcher;

public class NoteProperties {
    private static final Pattern patternMatcher = Pattern.compile("\\{(.*?)}");
    private final String notePattern;
    private final StreetNoteMatcher noteMatcher;

    public NoteProperties(String notePattern, StreetNoteMatcher noteMatcher) {
        this.notePattern = notePattern;
        this.noteMatcher = noteMatcher;
    }

    public StreetNoteAndMatcher generateNote(OsmEntity way) {
        I18NString text;
        if (patternMatcher.matcher(this.notePattern).matches()) {
            Map<String, String> noteText = way.generateI18NForPattern(this.notePattern);
            text = TranslatedString.getI18NString(noteText, true, false);
        } else {
            text = LocalizedStringMapper.getInstance().map(this.notePattern, way);
        }
        StreetNote note = new StreetNote(text);
        return new StreetNoteAndMatcher(note, this.noteMatcher);
    }
}

