/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.tagmapping;

import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.MixinPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.WayProperties;
import org.opentripplanner.osm.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.WayPropertySet;
import org.opentripplanner.osm.wayproperty.specifier.BestMatchSpecifier;
import org.opentripplanner.osm.wayproperty.specifier.ExactMatchSpecifier;
import org.opentripplanner.osm.wayproperty.specifier.LogicalOrSpecifier;
import org.opentripplanner.osm.wayproperty.specifier.OsmSpecifier;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class OsmTagMapper {
    public void populateProperties(WayPropertySet props) {
        WayProperties allWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).build();
        WayProperties noneWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE).build();
        WayProperties pedestrianWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).build();
        WayProperties pedestrianAndBicycleWayProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).build();
        props.setProperties("mtb:scale=3", noneWayProperties);
        props.setProperties("mtb:scale=4", noneWayProperties);
        props.setProperties("mtb:scale=5", noneWayProperties);
        props.setProperties("mtb:scale=6", noneWayProperties);
        props.setProperties("highway=bridleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE).bicycleSafety(1.3));
        props.setProperties("highway=corridor", pedestrianWayProperties);
        props.setProperties("highway=steps", pedestrianWayProperties);
        props.setProperties("highway=crossing", pedestrianWayProperties);
        props.setProperties("highway=platform", pedestrianWayProperties);
        props.setProperties("public_transport=platform", pedestrianWayProperties);
        props.setProperties("railway=platform", pedestrianWayProperties);
        props.setProperties("footway=sidewalk;highway=footway", pedestrianWayProperties);
        props.setProperties("highway=pedestrian", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).bicycleSafety(0.9));
        props.setProperties("highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).bicycleSafety(1.1));
        props.setProperties("mtb:scale=1", pedestrianWayProperties);
        props.setProperties("mtb:scale=2", pedestrianWayProperties);
        props.setProperties("highway=cycleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE).bicycleSafety(0.6));
        props.setProperties("mtb:scale=0", pedestrianAndBicycleWayProperties);
        props.setProperties("highway=path", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=living_street", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.9));
        props.setProperties("highway=unclassified", allWayProperties);
        props.setProperties("highway=road", allWayProperties);
        props.setProperties("highway=byway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=service", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary", allWayProperties);
        props.setProperties("highway=tertiary_link", allWayProperties);
        props.setProperties("highway=secondary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=secondary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=primary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=primary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.47));
        props.setProperties("highway=trunk_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.06));
        props.setProperties("highway=motorway_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(2.06));
        props.setProperties("highway=motorway", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(8.0));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier("motorroad=yes"), WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).walkSafety(7.47).bicycleSafety(7.47));
        props.setProperties("highway=*;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.87));
        props.setProperties("highway=service;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=tertiary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=tertiary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=secondary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=secondary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=primary;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=primary_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=trunk;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.5));
        props.setProperties("highway=trunk_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.15));
        props.setProperties("highway=motorway;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.0));
        props.setProperties("highway=motorway_link;cycleway=lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.15));
        props.setProperties("highway=*;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.92));
        props.setProperties("highway=service;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=residential;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=residential_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=tertiary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.92));
        props.setProperties("highway=tertiary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.92));
        props.setProperties("highway=secondary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.99));
        props.setProperties("highway=secondary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.99));
        props.setProperties("highway=primary;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=primary_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=trunk;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.75));
        props.setProperties("highway=trunk_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.25));
        props.setProperties("highway=motorway;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.5));
        props.setProperties("highway=motorway_link;cycleway=share_busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(1.25));
        props.setProperties("highway=*;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.87));
        props.setProperties("highway=service;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=tertiary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=tertiary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.87));
        props.setProperties("highway=secondary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=secondary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.96));
        props.setProperties("highway=primary;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=primary_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.15));
        props.setProperties("highway=trunk;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.47), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.47), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.15));
        props.setProperties("highway=trunk_link;cycleway=opposite_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(1.15));
        props.setProperties("highway=*;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=service;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=tertiary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=tertiary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=secondary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=secondary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=primary;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=primary_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=trunk;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(0.95));
        props.setProperties("highway=trunk_link;cycleway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(0.85));
        props.setProperties("highway=*;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("highway=service;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=residential_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.65));
        props.setProperties("highway=tertiary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=tertiary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.75));
        props.setProperties("highway=secondary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=secondary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.8));
        props.setProperties("highway=primary;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=primary_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.85));
        props.setProperties("highway=trunk;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.47), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.47), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(0.95));
        props.setProperties("highway=trunk_link;cycleway=opposite_track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(0.85));
        props.setProperties("highway=*;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.77));
        props.setProperties("highway=service;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.73));
        props.setProperties("highway=residential;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=residential_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.77));
        props.setProperties("highway=tertiary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.83));
        props.setProperties("highway=tertiary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.83));
        props.setProperties("highway=secondary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=secondary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.25));
        props.setProperties("highway=primary;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.75));
        props.setProperties("highway=primary_link;cycleway=shared_lane", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.75));
        props.setProperties("highway=*;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.4));
        props.setProperties("highway=service;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary;cycleway=opposite", allWayProperties);
        props.setProperties("highway=tertiary_link;cycleway=opposite", allWayProperties);
        props.setProperties("highway=secondary;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.71));
        props.setProperties("highway=secondary_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.71));
        props.setProperties("highway=primary;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.99));
        props.setProperties("highway=primary_link;cycleway=opposite", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.99));
        props.setProperties("highway=path;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=footway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier("highway=footway;bicycle=yes;area=yes"), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.9));
        props.setProperties("highway=pedestrian;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.75));
        props.setProperties("footway=sidewalk;highway=footway;bicycle=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(2.5));
        props.setProperties("footway=sidewalk;highway=footway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=footway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).bicycleSafety(2.5));
        props.setProperties("highway=footway;footway=crossing;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=track;bicycle=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.18));
        props.setProperties("highway=track;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.99));
        props.setProperties("highway=track;bicycle=yes;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.18));
        props.setProperties("highway=track;bicycle=designated;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.99));
        props.setProperties("highway=track;surface=*", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.3));
        props.setProperties("highway=*;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE).bicycleSafety(0.97));
        props.setProperties("highway=footway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=bridleway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE).bicycleSafety(0.8));
        props.setProperties("highway=service;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.84));
        props.setProperties("highway=residential;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=unclassified;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=residential_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.95));
        props.setProperties("highway=tertiary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.97));
        props.setProperties("highway=tertiary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.97));
        props.setProperties("highway=secondary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.46));
        props.setProperties("highway=secondary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.46));
        props.setProperties("highway=primary;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.0));
        props.setProperties("highway=primary_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.0));
        props.setProperties("highway=trunk;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(7.25));
        props.setProperties("highway=trunk_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).walkSafety(7.47).bicycleSafety(2.0));
        props.setProperties("highway=motorway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(7.76));
        props.setProperties("highway=motorway_link;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.BICYCLE_AND_CAR).bicycleSafety(2.0));
        props.setMixinProperties(new LogicalOrSpecifier("lcn=yes", "rcn=yes", "ncn=yes", "bicycle_road=yes", "cyclestreet=yes"), MixinPropertiesBuilder.ofBicycleSafety(0.7));
        props.setMixinProperties(new LogicalOrSpecifier("highway=trunk;sidewalk=yes", "highway=trunk;sidewalk=left", "highway=trunk;sidewalk=right", "highway=trunk;sidewalk=both"), MixinPropertiesBuilder.ofWalkSafety(0.25));
        props.setMixinProperties(new ExactMatchSpecifier("highway=trunk;sidewalk=lane"), MixinPropertiesBuilder.ofWalkSafety(0.6));
        props.setCarSpeed("highway=motorway", 29.0f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 24.6f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 20.0f);
        props.setCarSpeed("highway=primary_link", 11.2f);
        props.setCarSpeed("highway=secondary", 15.0f);
        props.setCarSpeed("highway=secondary_link", 11.2f);
        props.setCarSpeed("highway=tertiary", 11.2f);
        props.setCarSpeed("highway=tertiary_link", 11.2f);
        props.setCarSpeed("highway=living_street", 2.2f);
        props.setCarSpeed("highway=pedestrian", 2.2f);
        props.setCarSpeed("highway=residential", 11.2f);
        props.setCarSpeed("highway=unclassified", 11.2f);
        props.setCarSpeed("highway=service", 6.7f);
        props.setCarSpeed("highway=track", 4.5f);
        props.setCarSpeed("highway=road", 11.2f);
        props.defaultCarSpeed = Float.valueOf(11.2f);
        props.maxPossibleCarSpeed = Float.valueOf(38.0f);
        props.setMixinProperties("surface=unpaved", MixinPropertiesBuilder.ofBicycleSafety(1.18));
        props.setMixinProperties("surface=compacted", MixinPropertiesBuilder.ofBicycleSafety(1.18));
        props.setMixinProperties("surface=wood", MixinPropertiesBuilder.ofBicycleSafety(1.18));
        props.setMixinProperties("surface=cobblestone", MixinPropertiesBuilder.ofBicycleSafety(1.3));
        props.setMixinProperties("surface=sett", MixinPropertiesBuilder.ofBicycleSafety(1.3));
        props.setMixinProperties("surface=unhewn_cobblestone", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=grass_paver", MixinPropertiesBuilder.ofBicycleSafety(1.3));
        props.setMixinProperties("surface=pebblestone", MixinPropertiesBuilder.ofBicycleSafety(1.3));
        props.setMixinProperties("surface=metal", MixinPropertiesBuilder.ofBicycleSafety(1.3));
        props.setMixinProperties("surface=ground", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=dirt", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=earth", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=grass", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=mud", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=woodchip", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=gravel", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=artifical_turf", MixinPropertiesBuilder.ofBicycleSafety(1.5));
        props.setMixinProperties("surface=sand", MixinPropertiesBuilder.ofBicycleSafety(100.0));
        props.setMixinProperties("foot=discouraged", MixinPropertiesBuilder.ofWalkSafety(3.0));
        props.setMixinProperties("bicycle=discouraged", MixinPropertiesBuilder.ofBicycleSafety(3.0));
        props.setMixinProperties("foot=use_sidepath", MixinPropertiesBuilder.ofWalkSafety(5.0));
        props.setMixinProperties("bicycle=use_sidepath", MixinPropertiesBuilder.ofBicycleSafety(5.0));
        OsmTagMapper.populateNotesAndNames(props);
        props.setSlopeOverride(new BestMatchSpecifier("bridge=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("embankment=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("cutting=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("tunnel=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("location=underground"), true);
        props.setSlopeOverride(new BestMatchSpecifier("indoor=yes"), true);
    }

    static void populateNotesAndNames(WayPropertySet props) {
        props.createNotes("RLIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("CCGIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("surface=unpaved", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=compacted", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=ground", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=dirt", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=earth", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=grass", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=mud", "note.muddy_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("toll=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNotes("toll:motorcar=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNames("highway=cycleway", "name.bike_path");
        props.createNames("cycleway=track", "name.bike_path");
        props.createNames("highway=pedestrian", "name.pedestrian_path");
        props.createNames("highway=pedestrian;area=yes", "name.pedestrian_area");
        props.createNames("highway=path", "name.path");
        props.createNames("highway=footway", "name.pedestrian_path");
        props.createNames("highway=bridleway", "name.bridleway");
        props.createNames("highway=footway;bicycle=no", "name.pedestrian_path");
        props.createNames("highway=corridor", "name.corridor");
        props.createNames("indoor=corridor", "name.corridor");
        props.createNames("indoor=area", "name.indoor_area");
        props.createNames("otp:route_ref=*", "name.otp_route_ref");
        props.createNames("highway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;highway=footway;footway=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=path;path=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=pedestrian", "name.platform");
        props.createNames("railway=platform;highway=path", "name.platform");
        props.createNames("railway=platform;highway=footway", "name.platform");
        props.createNames("public_transport=platform", "name.platform");
        props.createNames("highway=platform", "name.platform");
        props.createNames("railway=platform", "name.platform");
        props.createNames("railway=platform;highway=footway;bicycle=no", "name.platform");
        props.createNames("highway=pedestrian;bridge=*", "name.footbridge");
        props.createNames("highway=path;bridge=*", "name.footbridge");
        props.createNames("highway=footway;bridge=*", "name.footbridge");
        props.createNames("highway=pedestrian;tunnel=*", "name.underpass");
        props.createNames("highway=path;tunnel=*", "name.underpass");
        props.createNames("highway=footway;tunnel=*", "name.underpass");
        props.createNames("highway=motorway", "name.road");
        props.createNames("highway=motorway_link", "name.ramp");
        props.createNames("highway=trunk", "name.road");
        props.createNames("highway=trunk_link", "name.ramp");
        props.createNames("highway=primary", "name.road");
        props.createNames("highway=primary_link", "name.link");
        props.createNames("highway=secondary", "name.road");
        props.createNames("highway=secondary_link", "name.link");
        props.createNames("highway=tertiary", "name.road");
        props.createNames("highway=tertiary_link", "name.link");
        props.createNames("highway=unclassified", "name.road");
        props.createNames("highway=residential", "name.road");
        props.createNames("highway=living_street", "name.road");
        props.createNames("highway=road", "name.road");
        props.createNames("highway=service", "name.service_road");
        props.createNames("highway=service;service=alley", "name.alley");
        props.createNames("highway=service;service=parking_aisle", "name.parking_aisle");
        props.createNames("highway=byway", "name.byway");
        props.createNames("highway=track", "name.track");
        props.createNames("highway=footway;footway=sidewalk", "name.sidewalk");
        props.createNames("highway=path;path=sidewalk", "name.sidewalk");
        props.createNames("highway=steps", "name.steps");
        props.createNames("amenity=bicycle_parking;name=*", "name.bicycle_parking_name");
        props.createNames("amenity=bicycle_parking", "name.bicycle_parking");
        props.createNames("amenity=parking;name=*", "name.park_and_ride_name");
        props.createNames("amenity=parking", "name.park_and_ride_station");
    }

    public boolean doesTagValueDisallowThroughTraffic(String tagValue) {
        return "no".equals(tagValue) || "destination".equals(tagValue) || "private".equals(tagValue) || "customers".equals(tagValue) || "delivery".equals(tagValue);
    }

    public float getCarSpeedForWay(OsmEntity way, TraverseDirection direction) {
        return way.getOsmProvider().getWayPropertySet().getCarSpeedForWay(way, direction);
    }

    public Float getMaxUsedCarSpeed(WayPropertySet wayPropertySet) {
        return Float.valueOf(wayPropertySet.maxUsedCarSpeed);
    }

    public boolean isGeneralNoThroughTraffic(OsmEntity way) {
        String access = way.getTag("access");
        return this.doesTagValueDisallowThroughTraffic(access);
    }

    public boolean isVehicleThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String vehicle = way.getTag("vehicle");
        if (vehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(vehicle);
        }
        return this.isGeneralNoThroughTraffic(way);
    }

    public boolean isMotorVehicleThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String motorVehicle = way.getTag("motor_vehicle");
        if (motorVehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(motorVehicle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    public boolean isBicycleThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String bicycle = way.getTag("bicycle");
        if (bicycle != null) {
            return this.doesTagValueDisallowThroughTraffic(bicycle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    public boolean isWalkThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String foot = way.getTag("foot");
        if (foot != null) {
            return this.doesTagValueDisallowThroughTraffic(foot);
        }
        return this.isGeneralNoThroughTraffic(way);
    }
}

