/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.tagmapping;

import java.util.Set;
import org.opentripplanner.framework.functional.FunctionUtils;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.osm.wayproperty.MixinPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.osm.wayproperty.WayPropertySet;
import org.opentripplanner.street.model.StreetTraversalPermission;

class FinlandMapper
extends OsmTagMapper {
    private static final Set<String> NOTHROUGH_DRIVING_TAGS = Set.of("parking_aisle", "driveway", "alley", "emergency_access", "drive-through");

    FinlandMapper() {
    }

    @Override
    public void populateProperties(WayPropertySet props) {
        FunctionUtils.TriFunction<StreetTraversalPermission, Float, OsmEntity, Double> defaultWalkSafetyForPermission = (permission, speedLimit, way) -> switch (permission) {
            default -> throw new MatchException(null, null);
            case StreetTraversalPermission.ALL, StreetTraversalPermission.PEDESTRIAN_AND_CAR -> {
                if (speedLimit.floatValue() <= 9.75f) {
                    yield 1.45;
                }
                if (speedLimit.floatValue() <= 16.65f) {
                    yield 1.6;
                }
                yield 1.8;
            }
            case StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE -> 1.15;
            case StreetTraversalPermission.PEDESTRIAN -> 1.1;
            case StreetTraversalPermission.BICYCLE_AND_CAR, StreetTraversalPermission.BICYCLE, StreetTraversalPermission.CAR, StreetTraversalPermission.NONE -> 1.8;
        };
        props.setDefaultWalkSafetyForPermission(defaultWalkSafetyForPermission);
        props.setProperties("highway=living_street", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.9));
        props.setProperties("highway=unclassified", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=road", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=byway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=service", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=tertiary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=secondary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=secondary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=primary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=primary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(7.47));
        props.setProperties("highway=trunk;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(7.47));
        props.setProperties("highway=*;informal=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=service;access=private", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=trail", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=*;seasonal=winter", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=*;ice_road=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=*;winter_road=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("footway=sidewalk;highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("highway=pedestrian", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.1));
        props.setProperties("highway=cycleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6).walkSafety(2.0));
        props.setProperties("highway=cycleway;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.1).bicycleSafety(0.6));
        props.setProperties("highway=footway;bridge=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.0));
        props.setProperties("highway=footway;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.0));
        props.setProperties("highway=cycleway;bridge=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.0).bicycleSafety(0.6));
        props.setProperties("highway=cycleway;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.0).bicycleSafety(0.6));
        props.setProperties("highway=footway;footway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.1));
        props.setProperties("highway=footway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.2));
        props.setProperties("highway=cycleway;cycleway=crossing;segregated=yes;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.1).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;footway=crossing;segregated=yes;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.1).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;cycleway=crossing;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.2).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;footway=crossing;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.2).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;cycleway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.15).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;footway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.15).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;cycleway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.25).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.25).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=service;tunnel=yes;access=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=service;access=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setMixinProperties("bicycle=use_sidepath", MixinPropertiesBuilder.ofWalkSafety(5.0));
        props.defaultCarSpeed = Float.valueOf(22.22f);
        props.maxPossibleCarSpeed = Float.valueOf(33.34f);
        props.setCarSpeed("highway=motorway", 27.77f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 22.22f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 22.22f);
        props.setCarSpeed("highway=primary_link", 15.0f);
        props.setCarSpeed("highway=secondary", 19.45f);
        props.setCarSpeed("highway=secondary_link", 15.0f);
        props.setCarSpeed("highway=tertiary", 16.65f);
        props.setCarSpeed("highway=tertiary_link", 11.2f);
        props.setCarSpeed("highway=unclassified", 11.2f);
        props.setCarSpeed("highway=road", 11.2f);
        props.setCarSpeed("highway=residential", 9.75f);
        props.setCarSpeed("highway=service", 5.55f);
        props.setCarSpeed("highway=living_street", 5.55f);
        props.setCarSpeed("highway=track", 4.5f);
        props.setCarSpeed("highway=pedestrian", 4.5f);
        super.populateProperties(props);
    }

    @Override
    public boolean isBicycleThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String bicycle = way.getTag("bicycle");
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way) || this.doesTagValueDisallowThroughTraffic(bicycle);
    }

    @Override
    public boolean isWalkThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        String foot = way.getTag("foot");
        return this.isGeneralNoThroughTraffic(way) || this.doesTagValueDisallowThroughTraffic(foot);
    }

    @Override
    public boolean isMotorVehicleThroughTrafficExplicitlyDisallowed(OsmEntity way) {
        if (super.isMotorVehicleThroughTrafficExplicitlyDisallowed(way)) {
            return true;
        }
        return way.isOneOfTags("service", NOTHROUGH_DRIVING_TAGS);
    }
}

