/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.tagmapping;

import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.tagmapping.FinlandMapper;
import org.opentripplanner.osm.wayproperty.WayPropertySet;

class ConstantSpeedFinlandMapper
extends FinlandMapper {
    private final float speed;

    public ConstantSpeedFinlandMapper() {
        this.speed = 22.22f;
    }

    public ConstantSpeedFinlandMapper(float speed) {
        this.speed = speed;
    }

    @Override
    public void populateProperties(WayPropertySet props) {
        props.setCarSpeed("highway=*", this.speed);
        super.populateProperties(props);
        props.maxPossibleCarSpeed = Float.valueOf(this.speed);
    }

    @Override
    public float getCarSpeedForWay(OsmEntity way, TraverseDirection direction) {
        return this.speed;
    }

    @Override
    public Float getMaxUsedCarSpeed(WayPropertySet wayPropertySet) {
        return Float.valueOf(this.speed);
    }
}

