/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.model;

import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.util.Set;
import org.opentripplanner.osm.model.OsmEntity;

public class OsmWay
extends OsmEntity {
    private static final Set<String> ESCALATOR_CONVEYING_TAGS = Set.of("yes", "forward", "backward", "reversible");
    private final TLongList nodes = new TLongArrayList();

    public void addNodeRef(long nodeRef) {
        this.nodes.add(nodeRef);
    }

    public void addNodeRef(long nodeRef, int index) {
        this.nodes.insert(index, nodeRef);
    }

    public TLongList getNodeRefs() {
        return this.nodes;
    }

    @Override
    public String toString() {
        return "osm way " + this.id;
    }

    public boolean isClosed() {
        int size = this.nodes.size();
        if (size > 2) {
            long b;
            long a = this.nodes.get(0);
            return a == (b = this.nodes.get(size - 1));
        }
        return false;
    }

    public boolean isBoardingArea() {
        return this.isBoardingLocation() && this.isClosed();
    }

    public boolean isSteps() {
        return this.isTag("highway", "steps");
    }

    @Override
    public boolean isWheelchairAccessible() {
        if (this.isSteps()) {
            return this.isTagTrue("wheelchair");
        }
        return super.isWheelchairAccessible();
    }

    public boolean isEscalator() {
        return this.isTag("highway", "steps") && this.isOneOfTags("conveying", ESCALATOR_CONVEYING_TAGS);
    }

    public boolean isForwardEscalator() {
        return this.isEscalator() && "forward".equals(this.getTag("conveying"));
    }

    public boolean isBackwardEscalator() {
        return this.isEscalator() && "backward".equals(this.getTag("conveying"));
    }

    public boolean isRoutableArea() {
        return !this.isTag("area", "no") && (this.isTag("area", "yes") || this.isParking() || this.isBikeParking() || this.isBoardingArea() || this.isIndoorRoutable()) && this.getNodeRefs().size() > 2;
    }

    public boolean isBarrier() {
        return this.hasTag("barrier");
    }

    @Override
    public String url() {
        return String.format("https://www.openstreetmap.org/way/%d", this.getId());
    }

    public boolean isRelevantForRouting() {
        return this.isRoutable() || this.isParkAndRide() || this.isBikeParking() || this.isBoardingLocation();
    }
}

