/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.model;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmRelationMember;

public class OsmRelation
extends OsmEntity {
    private final List<OsmRelationMember> members = new ArrayList<OsmRelationMember>();

    public void addMember(OsmRelationMember member) {
        this.members.add(member);
    }

    public List<OsmRelationMember> getMembers() {
        return this.members;
    }

    @Override
    public String toString() {
        return "osm relation " + this.id;
    }

    @Override
    public String url() {
        return String.format("https://www.openstreetmap.org/relation/%d", this.getId());
    }

    public boolean isBicycleRoute() {
        return this.isRoute() && this.isTag("route", "bicycle");
    }

    public boolean isRoute() {
        return this.isType("route");
    }

    public boolean isRoadRoute() {
        return this.isRoute() && this.isTag("route", "road");
    }

    public boolean isLevelMap() {
        return this.isType("level_map");
    }

    public boolean isRestriction() {
        return this.isType("restriction");
    }

    public boolean isPublicTransport() {
        return this.isType("public_transport");
    }

    public boolean isMultiPolygon() {
        return this.isType("multipolygon");
    }

    public boolean isStopArea() {
        return this.isPublicTransport() && this.isTag("public_transport", "stop_area");
    }

    private boolean isType(String type) {
        return this.isTag("type", type);
    }
}

