/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.model;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class OsmNode
extends OsmEntity {
    public double lat;
    public double lon;

    public OsmNode() {
    }

    public OsmNode(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    @Override
    public String toString() {
        return "osm node " + this.id;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.lon, this.lat);
    }

    public boolean isMultiLevel() {
        return this.isElevator();
    }

    public boolean hasHighwayTrafficLight() {
        return this.hasTag("highway") && "traffic_signals".equals(this.getTag("highway"));
    }

    public boolean hasCrossingTrafficLight() {
        return this.hasTag("crossing") && "traffic_signals".equals(this.getTag("crossing"));
    }

    public boolean isBarrier() {
        return this.overridePermissions(StreetTraversalPermission.ALL) != StreetTraversalPermission.ALL;
    }

    public boolean isSubwayEntrance() {
        return this.hasTag("railway") && "subway_entrance".equals(this.getTag("railway"));
    }

    @Override
    public String url() {
        return String.format("https://www.openstreetmap.org/node/%d", this.getId());
    }

    public boolean isTaggedBarrierCrossing() {
        return this.hasTag("barrier") || this.hasTag("access") || this.hasTag("entrance") || this.overridePermissions(StreetTraversalPermission.ALL) != StreetTraversalPermission.ALL || this.overridePermissions(StreetTraversalPermission.NONE) != StreetTraversalPermission.NONE;
    }
}

