/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.osm.issues.FloorNumberUnknownAssumedGroundLevel;
import org.opentripplanner.osm.issues.FloorNumberUnknownGuessedFromAltitude;
import org.opentripplanner.osm.model.OsmEntity;

public class OsmLevel
implements Comparable<OsmLevel> {
    public static final Pattern RANGE_PATTERN = Pattern.compile("^[0-9]+-[0-9]+$");
    public static final double METERS_PER_FLOOR = 3.0;
    public static final OsmLevel DEFAULT = new OsmLevel(0, 0.0, "default level", "default level", Source.NONE, true);
    public final int floorNumber;
    public final double altitudeMeters;
    public final String shortName;
    public final String longName;
    public final Source source;
    public final boolean reliable;

    public OsmLevel(int floorNumber, double altitudeMeters, String shortName, String longName, Source source, boolean reliable) {
        this.floorNumber = floorNumber;
        this.altitudeMeters = altitudeMeters;
        this.shortName = shortName;
        this.longName = longName;
        this.source = source;
        this.reliable = reliable;
    }

    public static OsmLevel fromString(String spec, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore, OsmEntity osmObj) {
        Double altitude = null;
        boolean reliable = true;
        int lastIndexAt = spec.lastIndexOf(64);
        if (lastIndexAt != -1) {
            try {
                altitude = Double.parseDouble(spec.substring(lastIndexAt + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            spec = spec.substring(0, lastIndexAt);
        }
        String shortName = "";
        String longName = "";
        int indexEquals = spec.indexOf(61);
        if (indexEquals >= 1) {
            shortName = spec.substring(0, indexEquals);
            longName = spec.substring(indexEquals + 1);
        } else {
            shortName = longName = spec;
        }
        if (longName.startsWith("+")) {
            longName = longName.substring(1);
        }
        if (shortName.startsWith("+")) {
            shortName = shortName.substring(1);
        }
        Integer floorNumber = null;
        try {
            floorNumber = Integer.parseInt(longName);
            if (incrementNonNegative) {
                if (source == Source.LEVEL_MAP) {
                    if (floorNumber >= 1) {
                        floorNumber = floorNumber - 1;
                    }
                } else if (floorNumber >= 0) {
                    longName = Integer.toString(floorNumber + 1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            floorNumber = Integer.parseInt(shortName);
            if (incrementNonNegative) {
                if (source == Source.LEVEL_MAP) {
                    if (floorNumber >= 1) {
                        floorNumber = floorNumber - 1;
                    }
                } else if (floorNumber >= 0) {
                    shortName = Integer.toString(floorNumber + 1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (floorNumber == null && altitude != null) {
            floorNumber = (int)(altitude / 3.0);
            issueStore.add(new FloorNumberUnknownGuessedFromAltitude(spec, floorNumber, osmObj));
            reliable = false;
        }
        if (altitude == null) {
            altitude = 0.0;
        }
        if (floorNumber == null) {
            floorNumber = 0;
            issueStore.add(new FloorNumberUnknownAssumedGroundLevel(spec, osmObj));
            reliable = false;
        }
        return new OsmLevel(floorNumber, altitude, shortName, longName, source, reliable);
    }

    public static List<OsmLevel> fromSpecList(String specList, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore, OsmEntity osmObj) {
        ArrayList<String> levelSpecs = new ArrayList<String>();
        for (String level : specList.split(";")) {
            Matcher m = RANGE_PATTERN.matcher(level);
            if (m.matches()) {
                String[] range = level.split("-");
                int endOfRange = Integer.parseInt(range[1]);
                for (int i = Integer.parseInt(range[0]); i <= endOfRange; ++i) {
                    levelSpecs.add(Integer.toString(i));
                }
                continue;
            }
            levelSpecs.add(level);
        }
        ArrayList<OsmLevel> levels = new ArrayList<OsmLevel>();
        for (String spec : levelSpecs) {
            levels.add(OsmLevel.fromString(spec, source, incrementNonNegative, issueStore, osmObj));
        }
        return levels;
    }

    public static Map<String, OsmLevel> mapFromSpecList(String specList, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore, OsmEntity osmObj) {
        HashMap<String, OsmLevel> map = new HashMap<String, OsmLevel>();
        for (OsmLevel level : OsmLevel.fromSpecList(specList, source, incrementNonNegative, issueStore, osmObj)) {
            map.put(level.shortName, level);
        }
        return map;
    }

    @Override
    public int compareTo(OsmLevel other) {
        return this.floorNumber - other.floorNumber;
    }

    public int hashCode() {
        return this.floorNumber;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof OsmLevel)) {
            return false;
        }
        return this.floorNumber == ((OsmLevel)other).floorNumber;
    }

    public static enum Source {
        LEVEL_MAP,
        LEVEL_TAG,
        LAYER_TAG,
        ALTITUDE,
        NONE;

    }
}

