/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm.model;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.osm.OsmProvider;
import org.opentripplanner.osm.model.OsmTag;
import org.opentripplanner.osm.model.Permission;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class OsmEntity {
    private static final Set<String> NON_ROUTABLE_HIGHWAYS = Set.of("proposed", "planned", "construction", "razed", "raceway", "abandoned", "historic", "no", "emergency_bay", "rest_area", "services", "bus_guideway", "escape");
    private static final Set<String> INDOOR_ROUTABLE_VALUES = Set.of("corridor", "area");
    private static final Set<String> LEVEL_TAGS = Set.of("level", "layer");
    private static final Set<String> DEFAULT_LEVEL = Set.of("0");
    protected static final Map<String, StreetTraversalPermission> BARRIER_PERMISSIONS = Map.ofEntries(Map.entry("cable_barrier", StreetTraversalPermission.PEDESTRIAN), Map.entry("city_wall", StreetTraversalPermission.NONE), Map.entry("ditch", StreetTraversalPermission.NONE), Map.entry("guard_rail", StreetTraversalPermission.PEDESTRIAN), Map.entry("handrail", StreetTraversalPermission.PEDESTRIAN), Map.entry("hedge", StreetTraversalPermission.NONE), Map.entry("retaining_wall", StreetTraversalPermission.NONE), Map.entry("wall", StreetTraversalPermission.NONE), Map.entry("block", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("bollard", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("bus_trap", StreetTraversalPermission.PEDESTRIAN), Map.entry("cycle_barrier", StreetTraversalPermission.PEDESTRIAN), Map.entry("debris", StreetTraversalPermission.PEDESTRIAN), Map.entry("full-height_turnstile", StreetTraversalPermission.PEDESTRIAN), Map.entry("horse_stile", StreetTraversalPermission.PEDESTRIAN), Map.entry("kent_carriage_gap", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("kissing_gate", StreetTraversalPermission.PEDESTRIAN), Map.entry("motorcycle_barrier", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("planter", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("stile", StreetTraversalPermission.PEDESTRIAN), Map.entry("sump_buster", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("turnstile", StreetTraversalPermission.PEDESTRIAN), Map.entry("wedge", StreetTraversalPermission.NONE), Map.entry("wicket_gate", StreetTraversalPermission.PEDESTRIAN), Map.entry("bar", StreetTraversalPermission.PEDESTRIAN), Map.entry("barrier_board", StreetTraversalPermission.PEDESTRIAN), Map.entry("chain", StreetTraversalPermission.PEDESTRIAN), Map.entry("fence", StreetTraversalPermission.NONE), Map.entry("jersey_barrier", StreetTraversalPermission.PEDESTRIAN), Map.entry("log", StreetTraversalPermission.PEDESTRIAN), Map.entry("rope", StreetTraversalPermission.PEDESTRIAN), Map.entry("tank_trap", StreetTraversalPermission.PEDESTRIAN), Map.entry("tyres", StreetTraversalPermission.PEDESTRIAN), Map.entry("delineator_kerb", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE), Map.entry("armadillo", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE));
    private static final Set<String> WHEELCHAIR_INACCESSIBLE_BARRIERS = Set.of("cable_barrier", "city_wall", "ditch", "guard_rail", "handrail", "hedge", "retaining_wall", "wall", "block", "bus_trap", "debris", "horse_stile", "stile", "turnstile", "wedge", "bar", "barrier_board", "chain", "fence", "jersey_barrier", "log", "tank_trap", "tyres");
    private static final Set<String> WHEELCHAIR_ACCESSIBLE_KERBS = Set.of("flush", "lowered", "no");
    private static final Consumer<String> NO_OP = i -> {};
    protected static final Set<String> CHECKED_MODES = Set.of("foot", "bicycle", "motorcar");
    private static final Map<String, String> MODE_HIERARACHY = Map.of("motorcar", "motor_vehicle", "motor_vehicle", "vehicle", "bicycle", "vehicle");
    public static final Set<String> NO_ACCESS_TAGS = Set.of("no", "license", "dismount");
    public static final Map<StreetTraversalPermission, String> OSM_TAGS_FOR_TRAVERSAL_PERMISSION = Map.of(StreetTraversalPermission.CAR, "motorcar", StreetTraversalPermission.BICYCLE, "bicycle", StreetTraversalPermission.PEDESTRIAN, "foot");
    private Map<String, String> tags;
    protected long id;
    protected I18NString creativeName;
    private OsmProvider osmProvider;

    public static boolean isFalse(String tagValue) {
        return "no".equals(tagValue) || "0".equals(tagValue) || "false".equals(tagValue);
    }

    public static boolean isTrue(String tagValue) {
        return "yes".equals(tagValue) || "1".equals(tagValue) || "true".equals(tagValue);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addTag(OsmTag tag) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(tag.getK().toLowerCase(), tag.getV());
    }

    public OsmEntity addTag(String key, String value) {
        if (key == null || value == null) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key.toLowerCase(), value);
        return this;
    }

    public Map<String, String> getTags() {
        return Objects.requireNonNullElse(this.tags, Map.of());
    }

    public boolean hasTag(String tag) {
        tag = tag.toLowerCase();
        return this.tags != null && this.tags.containsKey(tag);
    }

    public boolean isTagFalse(String tag) {
        tag = tag.toLowerCase();
        if (this.tags == null) {
            return false;
        }
        return OsmEntity.isFalse(this.getTag(tag));
    }

    public Accessibility explicitWheelchairAccessibility() {
        if (this.isTagTrue("wheelchair")) {
            return Accessibility.POSSIBLE;
        }
        if (this.isTagFalse("wheelchair")) {
            return Accessibility.NOT_POSSIBLE;
        }
        return Accessibility.NO_INFORMATION;
    }

    public boolean isTagTrue(String tag) {
        tag = tag.toLowerCase();
        if (this.tags == null) {
            return false;
        }
        return OsmEntity.isTrue(this.getTag(tag));
    }

    public boolean isBicycleDismountForced() {
        return this.isTag("bicycle", "dismount");
    }

    public boolean isSidewalk() {
        return this.isTag("footway", "sidewalk") && this.isTag("highway", "footway");
    }

    protected Optional<Permission> checkModePermission(String mode) {
        return this.checkModePermission(mode, TraverseDirection.DIRECTIONLESS);
    }

    protected Optional<Permission> checkModePermission(String mode, TraverseDirection direction) {
        if (direction != TraverseDirection.DIRECTIONLESS) {
            if (this.isExplicitlyAllowed(mode + direction.tagSuffix())) {
                return Optional.of(Permission.ALLOW);
            }
            if (this.isExplicitlyDenied(mode + direction.tagSuffix())) {
                return Optional.of(Permission.DENY);
            }
        }
        if (this.isExplicitlyAllowed(mode)) {
            return Optional.of(Permission.ALLOW);
        }
        if (this.isExplicitlyDenied(mode)) {
            return Optional.of(Permission.DENY);
        }
        String parentMode = MODE_HIERARACHY.get(mode);
        return parentMode == null ? Optional.empty() : this.checkModePermission(parentMode, direction);
    }

    protected boolean isExplicitlyAllowed(String key) {
        if (this.tags == null) {
            return false;
        }
        if (this.isTagTrue(key)) {
            return true;
        }
        String value = this.getTag(key = key.toLowerCase());
        return "designated".equals(value) || "official".equals(value) || "permissive".equals(value) || "unknown".equals(value);
    }

    @Nullable
    public String getTag(String tag) {
        tag = tag.toLowerCase();
        if (this.tags != null && this.tags.containsKey(tag)) {
            return this.tags.get(tag);
        }
        return null;
    }

    public Optional<String> getTagOpt(String network) {
        return Optional.ofNullable(this.getTag(network));
    }

    public OptionalInt getTagAsInt(String tag, Consumer<String> errorHandler) {
        String value = this.getTag(tag);
        if (value != null) {
            try {
                return OptionalInt.of(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                errorHandler.accept(value);
            }
        }
        return OptionalInt.empty();
    }

    public static Duration parseOsmDuration(String duration) {
        int colonCount = (int)duration.chars().filter(ch -> ch == 58).count();
        if (colonCount <= 2) {
            try {
                switch (colonCount) {
                    case 0: {
                        long minutes = Long.parseLong(duration);
                        if (minutes >= 0L) {
                            return Duration.ofMinutes(minutes);
                        }
                        break;
                    }
                    case 1: {
                        int i = duration.indexOf(58);
                        long hours = Long.parseLong(duration.substring(0, i));
                        long minutes = Long.parseLong(duration.substring(i + 1));
                        if (duration.length() - i == 3 && hours >= 0L && minutes >= 0L && minutes < 60L) {
                            return Duration.ofHours(hours).plusMinutes(minutes);
                        }
                        break;
                    }
                    default: {
                        int i = duration.indexOf(58);
                        int j = duration.indexOf(58, i + 1);
                        long hours = Long.parseLong(duration.substring(0, i));
                        long minutes = Long.parseLong(duration.substring(i + 1, j));
                        long seconds = Long.parseLong(duration.substring(j + 1));
                        if (j - i == 3 && duration.length() - j == 3 && hours >= 0L && minutes >= 0L && minutes < 60L && seconds >= 0L && seconds < 60L) {
                            return Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new DateTimeParseException("Bad OSM duration", duration, 0);
    }

    public Optional<Duration> getTagValueAsDuration(String key, Consumer<String> errorHandler) {
        String value = this.getTag(key);
        if (value != null) {
            try {
                return Optional.of(OsmEntity.parseOsmDuration(value));
            }
            catch (DateTimeParseException e) {
                errorHandler.accept(value);
            }
        }
        return Optional.empty();
    }

    public Optional<Duration> getDuration(Consumer<String> errorHandler) {
        return this.getTagValueAsDuration("duration", errorHandler);
    }

    public OptionalInt parseIntOrBoolean(String tag, Consumer<String> errorHandler) {
        OptionalInt maybeInt = this.getTagAsInt(tag, NO_OP);
        if (maybeInt.isPresent()) {
            return maybeInt;
        }
        if (this.isTagTrue(tag)) {
            return OptionalInt.of(1);
        }
        if (this.isTagFalse(tag)) {
            return OptionalInt.of(0);
        }
        if (this.hasTag(tag)) {
            errorHandler.accept(this.getTag(tag));
            return OptionalInt.empty();
        }
        return OptionalInt.empty();
    }

    public boolean isTag(String tag, String value) {
        tag = tag.toLowerCase();
        if (this.tags != null && this.tags.containsKey(tag) && value != null) {
            return value.equals(this.tags.get(tag));
        }
        return false;
    }

    public boolean isOneOfTags(String key, Set<String> oneOfTags) {
        return oneOfTags.stream().anyMatch(value -> this.isTag(key, (String)value));
    }

    @Nullable
    public I18NString getAssumedName() {
        if (this.tags == null) {
            return null;
        }
        if (this.tags.containsKey("name")) {
            return TranslatedString.getI18NString(this.generateI18NForPattern("{name}"), true, false);
        }
        if (this.tags.containsKey("otp:route_name")) {
            return new NonLocalizedString(this.tags.get("otp:route_name"));
        }
        if (this.creativeName != null) {
            return this.creativeName;
        }
        if (this.tags.containsKey("otp:route_ref")) {
            return new NonLocalizedString(this.tags.get("otp:route_ref"));
        }
        if (this.tags.containsKey("ref")) {
            return new NonLocalizedString(this.tags.get("ref"));
        }
        return null;
    }

    public Map<String, String> generateI18NForPattern(String pattern) {
        HashMap<String, StringBuffer> i18n = new HashMap<String, StringBuffer>();
        i18n.put(null, new StringBuffer());
        Matcher matcher = Pattern.compile("\\{(.*?)}").matcher(pattern);
        int lastEnd = 0;
        while (matcher.find()) {
            for (StringBuffer sb : i18n.values()) {
                sb.append(pattern, lastEnd, matcher.start());
            }
            lastEnd = matcher.end();
            String defKey = matcher.group(1);
            Map<String, String> i18nTags = this.getTagsByPrefix(defKey);
            for (Map.Entry<String, String> kv : i18nTags.entrySet()) {
                String lang;
                if (kv.getKey().equals(defKey) || i18n.containsKey(lang = kv.getKey().substring(defKey.length() + 1))) continue;
                i18n.put(lang, new StringBuffer((CharSequence)i18n.get(null)));
            }
            String defTag = this.getTag(defKey);
            if (defTag == null && !i18nTags.isEmpty()) {
                defTag = i18nTags.values().iterator().next();
            }
            for (String lang : i18n.keySet()) {
                String i18nTag = this.getTag((String)defKey + ":" + lang);
                ((StringBuffer)i18n.get(lang)).append(i18nTag != null ? i18nTag : (defTag != null ? defTag : ""));
            }
        }
        for (StringBuffer sb : i18n.values()) {
            sb.append(pattern, lastEnd, pattern.length());
        }
        HashMap<String, String> out = new HashMap<String, String>(i18n.size());
        for (Map.Entry kv : i18n.entrySet()) {
            out.put((String)kv.getKey(), ((StringBuffer)kv.getValue()).toString());
        }
        return out;
    }

    private Map<String, String> getTagsByPrefix(String prefix) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            String k = entry.getKey();
            if (!k.equals(prefix) && !k.startsWith(prefix + ":")) continue;
            out.put(k, entry.getValue());
        }
        return out;
    }

    public boolean isUnderConstruction() {
        String highway = this.getTag("highway");
        String cycleway = this.getTag("cycleway");
        return "construction".equals(highway) || "construction".equals(cycleway);
    }

    public boolean isGeneralAccessDenied() {
        return this.isGeneralAccessDenied(TraverseDirection.DIRECTIONLESS);
    }

    public boolean isGeneralAccessDenied(TraverseDirection direction) {
        return this.checkModePermission("access", direction).map(x -> x == Permission.DENY).orElse(false);
    }

    public Optional<TraverseDirection> isOneWay(@Nullable String mode) {
        TraverseDirection direction;
        Optional<Optional<TraverseDirection>> explicitResult = this.isExplicitlyOneWay(mode);
        if (explicitResult.isPresent()) {
            return explicitResult.get();
        }
        if ("bicycle".equals(mode) && this.isOpposableCycleway()) {
            return Optional.empty();
        }
        if ("foot".equals(mode) && !this.isOneOfTags("highway", Set.of("footway", "step", "corridor"))) {
            return Optional.empty();
        }
        if (mode == null) {
            return this.isTag("highway", "motorway") || this.isRoundabout() ? Optional.of(TraverseDirection.FORWARD) : Optional.empty();
        }
        Optional<TraverseDirection> parentModeResult = this.isOneWay(MODE_HIERARACHY.get(mode));
        if (parentModeResult.isPresent() && this.isExplicitlyAllowed(mode + (direction = parentModeResult.get()).reverse().tagSuffix())) {
            return Optional.empty();
        }
        return parentModeResult;
    }

    private Optional<Optional<TraverseDirection>> isExplicitlyOneWay(@Nullable String mode) {
        Object key;
        Object object = key = mode == null ? "oneway" : "oneway:" + mode;
        if (this.isTagFalse((String)key)) {
            return Optional.of(Optional.empty());
        }
        if (this.isTagTrue((String)key)) {
            return Optional.of(Optional.of(TraverseDirection.FORWARD));
        }
        return this.isTag((String)key, "-1") ? Optional.of(Optional.of(TraverseDirection.BACKWARD)) : Optional.empty();
    }

    public boolean isBicycleDenied() {
        return this.checkModePermission("bicycle").equals(Optional.of(Permission.DENY));
    }

    public boolean isPedestrianDenied() {
        return this.checkModePermission("foot").equals(Optional.of(Permission.DENY));
    }

    public boolean isParking() {
        return this.isTag("amenity", "parking");
    }

    public boolean isParkAndRide() {
        String parkingType = this.getTag("parking");
        String parkAndRide = this.getTag("park_ride");
        return this.isParking() && (parkingType != null && parkingType.contains("park_and_ride") || parkAndRide != null && !parkAndRide.equalsIgnoreCase("no"));
    }

    public boolean isBoardingLocation() {
        return this.isTag("highway", "bus_stop") || this.isTag("railway", "tram_stop") || this.isTag("railway", "station") || this.isTag("railway", "halt") || this.isTag("amenity", "bus_station") || this.isTag("amenity", "ferry_terminal") || this.isTag("highway", "platform") || this.isPlatform();
    }

    public boolean isPlatform() {
        boolean isPlatform = this.isTag("public_transport", "platform") || this.isRailwayPlatform();
        return isPlatform && !this.isTag("usage", "tourism");
    }

    public boolean isRailwayPlatform() {
        return this.isTag("railway", "platform");
    }

    public boolean isEntrance() {
        return (this.isTag("railway", "subway_entrance") || this.isTag("highway", "elevator") || this.isTag("entrance", "yes") || this.isTag("entrance", "main")) && !this.isTag("access", "private") && !this.isTag("access", "no");
    }

    public boolean isBikeParking() {
        return this.isTag("amenity", "bicycle_parking") && !this.isTag("access", "private") && !this.isTag("access", "no");
    }

    public void setCreativeName(I18NString creativeName) {
        this.creativeName = creativeName;
    }

    public boolean isRoundabout() {
        return "roundabout".equals(this.getTag("junction"));
    }

    public boolean isOpposableCycleway() {
        String cycleway = this.getTag("cycleway");
        String cyclewayLeft = this.getTag("cycleway:left");
        String cyclewayRight = this.getTag("cycleway:right");
        return cycleway != null && cycleway.startsWith("opposite") || cyclewayLeft != null && cyclewayLeft.startsWith("opposite") || cyclewayRight != null && cyclewayRight.startsWith("opposite");
    }

    @Nullable
    public String url() {
        return null;
    }

    public Set<String> getMultiTagValues(Set<String> refTags) {
        return refTags.stream().map(this::getTag).filter(Objects::nonNull).flatMap(v -> Arrays.stream(v.split(";"))).map(String::strip).filter(v -> !v.isBlank()).collect(Collectors.toUnmodifiableSet());
    }

    public OsmProvider getOsmProvider() {
        return this.osmProvider;
    }

    public void setOsmProvider(OsmProvider provider) {
        this.osmProvider = provider;
    }

    public boolean isRoutable() {
        if (this.isOneOfTags("highway", NON_ROUTABLE_HIGHWAYS)) {
            return false;
        }
        if (this.hasTag("highway") || this.isPlatform() || this.isIndoorRoutable()) {
            if (this.isGeneralAccessDenied(TraverseDirection.DIRECTIONLESS) && this.isGeneralAccessDenied(TraverseDirection.FORWARD) && this.isGeneralAccessDenied(TraverseDirection.BACKWARD)) {
                for (String mode : CHECKED_MODES) {
                    for (TraverseDirection direction : TraverseDirection.values()) {
                        if (!this.checkModePermission(mode, direction).equals(Optional.of(Permission.ALLOW))) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isIndoorRoutable() {
        return this.isOneOfTags("indoor", INDOOR_ROUTABLE_VALUES);
    }

    public boolean isLink() {
        String highway = this.getTag("highway");
        return highway != null && highway.endsWith("_link");
    }

    public boolean isElevator() {
        return this.isTag("highway", "elevator");
    }

    public boolean isWheelchairAccessible() {
        if (this.isTagTrue("wheelchair")) {
            return true;
        }
        if (this.isTagFalse("wheelchair")) {
            return false;
        }
        if (this.isOneOfTags("barrier", WHEELCHAIR_INACCESSIBLE_BARRIERS)) {
            return false;
        }
        if (this.isTag("barrier", "kerb")) {
            return this.isOneOfTags("kerb", WHEELCHAIR_ACCESSIBLE_KERBS);
        }
        return true;
    }

    public boolean isNamed() {
        return this.hasTag("name") || this.hasTag("ref");
    }

    public boolean hasNoName() {
        return !this.isNamed();
    }

    public boolean isExplicitlyUnnamed() {
        return this.isTagTrue("noname");
    }

    private boolean isExplicitlyDenied(String key) {
        return this.isOneOfTags(key, NO_ACCESS_TAGS);
    }

    public Set<String> getLevels() {
        Set<String> levels = this.getMultiTagValues(LEVEL_TAGS);
        if (levels.isEmpty()) {
            return DEFAULT_LEVEL;
        }
        return levels;
    }

    public StreetTraversalPermission getPermission() {
        return this.getPermission(TraverseDirection.DIRECTIONLESS);
    }

    public StreetTraversalPermission getPermission(TraverseDirection direction) {
        return this.getOsmProvider().getWayPropertySet().getDataForEntity(this, direction).getPermission();
    }

    private StreetTraversalPermission getBarrierPermission() {
        String barrier = this.getTag("barrier");
        if (barrier == null) {
            return StreetTraversalPermission.ALL;
        }
        return Objects.requireNonNullElse(BARRIER_PERMISSIONS.get(barrier), StreetTraversalPermission.ALL);
    }

    public StreetTraversalPermission overridePermissions(StreetTraversalPermission def) {
        return this.overridePermissions(def, TraverseDirection.DIRECTIONLESS);
    }

    public StreetTraversalPermission overridePermissions(StreetTraversalPermission def, TraverseDirection direction) {
        StreetTraversalPermission permission = def;
        permission = permission.intersection(this.getBarrierPermission());
        if (this.isGeneralAccessDenied(direction)) {
            permission = StreetTraversalPermission.NONE;
        }
        for (Map.Entry<StreetTraversalPermission, String> entry : OSM_TAGS_FOR_TRAVERSAL_PERMISSION.entrySet()) {
            Optional<Permission> modePermission = this.checkModePermission(entry.getValue(), direction);
            if (modePermission.isPresent()) {
                switch (modePermission.get()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ALLOW: {
                        StreetTraversalPermission streetTraversalPermission = permission.add(entry.getKey());
                        break;
                    }
                    case DENY: {
                        StreetTraversalPermission streetTraversalPermission = permission = permission.remove(entry.getKey());
                    }
                }
            }
            if (!this.isOneWay(entry.getValue()).map(wayDirection -> wayDirection != direction).orElse(false).booleanValue()) continue;
            permission = permission.remove(entry.getKey());
        }
        if (this.isUnderConstruction()) {
            permission = StreetTraversalPermission.NONE;
        }
        return permission;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("tags", this.tags).toString();
    }
}

