/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.osm.DefaultOsmProvider;
import org.opentripplanner.osm.OsmParserPhase;
import org.opentripplanner.osm.model.OsmMemberType;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmRelation;
import org.opentripplanner.osm.model.OsmRelationMember;
import org.opentripplanner.osm.model.OsmTag;
import org.opentripplanner.osm.model.OsmWay;

class OsmParser
extends BinaryParser {
    private final OsmDatabase osmdb;
    private final Map<String, String> stringTable = new HashMap<String, String>();
    private final DefaultOsmProvider provider;
    private OsmParserPhase parsePhase;

    public OsmParser(OsmDatabase osmdb, DefaultOsmProvider provider) {
        this.osmdb = Objects.requireNonNull(osmdb);
        this.provider = Objects.requireNonNull(provider);
    }

    public String internalize(String s) {
        String fromTable = this.stringTable.get(s);
        if (fromTable == null) {
            this.stringTable.put(s, s);
            return s;
        }
        return fromTable;
    }

    public void complete() {
    }

    public void setPhase(OsmParserPhase phase) {
        this.parsePhase = phase;
    }

    protected void parseRelations(List<Osmformat.Relation> rels) {
        if (this.parsePhase != OsmParserPhase.Relations) {
            return;
        }
        for (Osmformat.Relation i : rels) {
            OsmRelation tmp = new OsmRelation();
            tmp.setId(i.getId());
            tmp.setOsmProvider(this.provider);
            for (int j = 0; j < i.getKeysCount(); ++j) {
                OsmTag tag = new OsmTag();
                String key = this.internalize(this.getStringById(i.getKeys(j)));
                String value = this.internalize(this.getStringById(i.getVals(j)));
                tag.setK(key);
                tag.setV(value);
                tmp.addTag(tag);
            }
            long lastMid = 0L;
            for (int j = 0; j < i.getMemidsCount(); ++j) {
                OsmRelationMember relMember = new OsmRelationMember();
                long mid = lastMid + i.getMemids(j);
                relMember.setRef(mid);
                lastMid = mid;
                relMember.setRole(this.internalize(this.getStringById(i.getRolesSid(j))));
                if (i.getTypes(j) == Osmformat.Relation.MemberType.NODE) {
                    relMember.setType(OsmMemberType.NODE);
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.WAY) {
                    relMember.setType(OsmMemberType.WAY);
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.RELATION) {
                    relMember.setType(OsmMemberType.RELATION);
                } else assert (false);
                tmp.addMember(relMember);
            }
            this.osmdb.addRelation(tmp);
        }
    }

    protected void parseDense(Osmformat.DenseNodes nodes) {
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        if (this.parsePhase != OsmParserPhase.Nodes) {
            return;
        }
        for (int i = 0; i < nodes.getIdCount(); ++i) {
            long id;
            long lon;
            long lat;
            OsmNode tmp = new OsmNode();
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            tmp.setId(id);
            tmp.setOsmProvider(this.provider);
            tmp.lat = latf;
            tmp.lon = lonf;
            if (nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    OsmTag tag = new OsmTag();
                    String key = this.internalize(this.getStringById(keyid));
                    String value = this.internalize(this.getStringById(valid));
                    tag.setK(key);
                    tag.setV(value);
                    tmp.addTag(tag);
                }
                ++j;
            }
            this.osmdb.addNode(tmp);
        }
    }

    protected void parseNodes(List<Osmformat.Node> nodes) {
        if (this.parsePhase != OsmParserPhase.Nodes) {
            return;
        }
        for (Osmformat.Node i : nodes) {
            OsmNode tmp = new OsmNode();
            tmp.setId(i.getId());
            tmp.setOsmProvider(this.provider);
            tmp.lat = this.parseLat(i.getLat());
            tmp.lon = this.parseLon(i.getLon());
            for (int j = 0; j < i.getKeysCount(); ++j) {
                String key = this.internalize(this.getStringById(i.getKeys(j)));
                String value = this.internalize(this.getStringById(i.getVals(j)));
                OsmTag tag = new OsmTag();
                tag.setK(key);
                tag.setV(value);
                tmp.addTag(tag);
            }
            this.osmdb.addNode(tmp);
        }
    }

    protected void parseWays(List<Osmformat.Way> ways) {
        if (this.parsePhase != OsmParserPhase.Ways) {
            return;
        }
        for (Osmformat.Way i : ways) {
            OsmWay tmp = new OsmWay();
            tmp.setId(i.getId());
            tmp.setOsmProvider(this.provider);
            for (int j = 0; j < i.getKeysCount(); ++j) {
                OsmTag tag = new OsmTag();
                String key = this.internalize(this.getStringById(i.getKeys(j)));
                String value = this.internalize(this.getStringById(i.getVals(j)));
                tag.setK(key);
                tag.setV(value);
                tmp.addTag(tag);
            }
            long lastId = 0L;
            Iterator iterator = i.getRefsList().iterator();
            while (iterator.hasNext()) {
                long j = (Long)iterator.next();
                tmp.addNodeRef(j + lastId);
                lastId = j + lastId;
            }
            this.osmdb.addWay(tmp);
        }
    }

    public void parse(Osmformat.HeaderBlock block) {
        for (String s : block.getRequiredFeaturesList()) {
            if (s.equals("OsmSchema-V0.6") || s.equals("DenseNodes")) continue;
            throw new IllegalStateException("File requires unknown feature: " + s);
        }
    }
}

