/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.osm;

import crosby.binary.file.BlockInputStream;
import crosby.binary.file.BlockReaderAdapter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.osm.OsmParser;
import org.opentripplanner.osm.OsmParserPhase;
import org.opentripplanner.osm.OsmProvider;
import org.opentripplanner.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.osm.tagmapping.OsmTagMapperSource;
import org.opentripplanner.osm.wayproperty.WayPropertySet;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOsmProvider
implements OsmProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOsmProvider.class);
    private final DataSource source;
    private final boolean cacheDataInMem;
    private final ZoneId zoneId;
    private boolean hasWarnedAboutMissingTimeZone = false;
    private final OsmTagMapper osmTagMapper;
    private final WayPropertySet wayPropertySet;
    private byte[] cachedBytes = null;

    public DefaultOsmProvider(File file, boolean cacheDataInMem) {
        this(new FileDataSource(file, FileType.OSM), OsmTagMapperSource.DEFAULT, null, cacheDataInMem, DataImportIssueStore.NOOP);
    }

    public DefaultOsmProvider(DataSource dataSource, OsmTagMapperSource tagMapperSource, ZoneId zoneId, boolean cacheDataInMem, DataImportIssueStore issueStore) {
        this.source = dataSource;
        this.zoneId = zoneId;
        this.osmTagMapper = tagMapperSource.getInstance();
        this.wayPropertySet = new WayPropertySet(issueStore);
        this.osmTagMapper.populateProperties(this.wayPropertySet);
        this.cacheDataInMem = cacheDataInMem;
    }

    @Override
    public void readOsm(OsmDatabase osmdb) {
        try {
            OsmParser parser = new OsmParser(osmdb, this);
            this.parsePhase(parser, OsmParserPhase.Relations);
            osmdb.doneFirstPhaseRelations();
            this.parsePhase(parser, OsmParserPhase.Ways);
            osmdb.doneSecondPhaseWays();
            this.parsePhase(parser, OsmParserPhase.Nodes);
            osmdb.doneThirdPhaseNodes();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error loading OSM from path " + this.source.path(), ex);
        }
    }

    public String toString() {
        return ToStringBuilder.of(DefaultOsmProvider.class).addObj("source", (Object)this.source).addBool("cacheDataInMem", Boolean.valueOf(this.cacheDataInMem)).toString();
    }

    @Override
    public void checkInputs() {
        if (!this.source.exists()) {
            throw new RuntimeException("Can't read OSM path: " + this.source.path());
        }
    }

    private static InputStream track(OsmParserPhase phase, long size, InputStream inputStream) {
        return ProgressTracker.track((String)("Parse OSM " + String.valueOf((Object)phase)), (int)1000, (long)size, (InputStream)inputStream, m -> LOG.info(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePhase(OsmParser parser, OsmParserPhase phase) throws IOException {
        parser.setPhase(phase);
        BlockInputStream in = null;
        try {
            in = new BlockInputStream(this.createInputStream(phase), (BlockReaderAdapter)parser);
            in.process();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InputStream createInputStream(OsmParserPhase phase) {
        if (this.cacheDataInMem) {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.source.asBytes();
            }
            return DefaultOsmProvider.track(phase, this.cachedBytes.length, new ByteArrayInputStream(this.cachedBytes));
        }
        return DefaultOsmProvider.track(phase, this.source.size(), this.source.asInputStream());
    }

    @Override
    public ZoneId getZoneId() {
        if (this.zoneId == null && !this.hasWarnedAboutMissingTimeZone) {
            this.hasWarnedAboutMissingTimeZone = true;
            LOG.warn("Missing time zone for OSM source {} - time-restricted entities will not be created, please configure it in the {}", (Object)this.source.uri(), (Object)"build-config.json");
        }
        return this.zoneId;
    }

    @Override
    public OsmTagMapper getOsmTagMapper() {
        return this.osmTagMapper;
    }

    @Override
    public WayPropertySet getWayPropertySet() {
        return this.wayPropertySet;
    }
}

