/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import java.util.List;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.support.ServiceJourneyInfo;
import org.opentripplanner.netex.support.stoptime.StopTimeAdaptor;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.rutebanken.netex.model.ServiceJourney;

class ServiceJourneyNonIncreasingPassingTime
extends AbstractHMapValidationRule<String, ServiceJourney> {
    private StopTimeAdaptor invalidTimetabledPassingTimeInfo;
    private ErrorType errorType;

    ServiceJourneyNonIncreasingPassingTime() {
    }

    @Override
    public HMapValidationRule.Status validate(ServiceJourney sj) {
        ServiceJourneyInfo serviceJourneyInfo = new ServiceJourneyInfo(sj, this.index);
        List<StopTimeAdaptor> orderedPassingTimes = serviceJourneyInfo.orderedTimetabledPassingTimeInfos();
        StopTimeAdaptor previousPassingTime = orderedPassingTimes.get(0);
        if (!previousPassingTime.isComplete()) {
            return this.discard(previousPassingTime, ErrorType.INCOMPLETE);
        }
        if (!previousPassingTime.isConsistent()) {
            return this.discard(previousPassingTime, ErrorType.INCONSISTENT);
        }
        for (int i = 1; i < orderedPassingTimes.size(); ++i) {
            StopTimeAdaptor currentPassingTime = orderedPassingTimes.get(i);
            if (!currentPassingTime.isComplete()) {
                return this.discard(currentPassingTime, ErrorType.INCOMPLETE);
            }
            if (!currentPassingTime.isConsistent()) {
                return this.discard(currentPassingTime, ErrorType.INCONSISTENT);
            }
            if (!previousPassingTime.isStopTimesIncreasing(currentPassingTime)) {
                return this.discard(currentPassingTime, ErrorType.NON_INCREASING);
            }
            previousPassingTime = currentPassingTime;
        }
        return HMapValidationRule.Status.OK;
    }

    @Override
    public DataImportIssue logMessage(String key, ServiceJourney sj) {
        return Issue.issue(this.errorType.type, "%s ServiceJourney will be skipped. ServiceJourney = %s, TimetabledPassingTime = %s", this.errorType.message, sj.getId(), this.invalidTimetabledPassingTimeInfo.timetabledPassingTimeId());
    }

    private HMapValidationRule.Status discard(StopTimeAdaptor stopTime, ErrorType errorType) {
        this.invalidTimetabledPassingTimeInfo = stopTime;
        this.errorType = errorType;
        return HMapValidationRule.Status.DISCARD;
    }

    private static enum ErrorType {
        INCOMPLETE("TimetabledPassingTimeIncompleteTime", "ServiceJourney has incomplete TimetabledPassingTime."),
        INCONSISTENT("TimetabledPassingTimeInconsistentTime", "ServiceJourney has inconsistent TimetabledPassingTime."),
        NON_INCREASING("TimetabledPassingTimeNonIncreasingTime", "ServiceJourney has non-increasing TimetabledPassingTime.");

        private final String type;
        private final String message;

        private ErrorType(String type, String message) {
            this.type = type;
            this.message = message;
        }
    }
}

