/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import java.util.function.Predicate;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.JourneyPattern_VersionStructure;
import org.rutebanken.netex.model.PointInLinkSequence_VersionedChildStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.StopPointInJourneyPattern;
import org.rutebanken.netex.model.StopUseEnumeration;

class JourneyPatternSJMismatch
extends AbstractHMapValidationRule<String, ServiceJourney> {
    JourneyPatternSJMismatch() {
    }

    @Override
    public HMapValidationRule.Status validate(ServiceJourney sj) {
        int nTimetablePassingTimes;
        JourneyPattern_VersionStructure journeyPattern = (JourneyPattern_VersionStructure)this.index.getJourneyPatternsById().lookup(this.getPatternId(sj));
        int nStopPointsInJourneyPattern = (int)journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().stream().filter(Predicate.not(JourneyPatternSJMismatch::isPassThrough)).count();
        return nStopPointsInJourneyPattern != (nTimetablePassingTimes = sj.getPassingTimes().getTimetabledPassingTime().size()) ? HMapValidationRule.Status.DISCARD : HMapValidationRule.Status.OK;
    }

    private static boolean isPassThrough(PointInLinkSequence_VersionedChildStructure point) {
        StopPointInJourneyPattern spijp;
        return point instanceof StopPointInJourneyPattern && (spijp = (StopPointInJourneyPattern)point).getStopUse() == StopUseEnumeration.PASSTHROUGH;
    }

    @Override
    public DataImportIssue logMessage(String key, ServiceJourney sj) {
        return new StopPointsMismatch(sj.getId(), this.getPatternId(sj));
    }

    private String getPatternId(ServiceJourney sj) {
        return ((JourneyPatternRefStructure)sj.getJourneyPatternRef().getValue()).getRef();
    }

    private static class StopPointsMismatch
    implements DataImportIssue {
        private final String sjId;
        private final String patternId;

        public StopPointsMismatch(String sjId, String patternId) {
            this.sjId = sjId;
            this.patternId = patternId;
        }

        @Override
        public String getMessage() {
            return "Mismatch in stop points between ServiceJourney and JourneyPattern. ServiceJourney will be skipped.  ServiceJourney=" + this.sjId + ", JourneyPattern= " + this.patternId;
        }
    }
}

