/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support.stoptime;

import org.opentripplanner.netex.support.ServiceJourneyHelper;
import org.opentripplanner.netex.support.stoptime.AbstractStopTimeAdaptor;
import org.rutebanken.netex.model.TimetabledPassingTime;

final class RegularStopTimeAdaptor
extends AbstractStopTimeAdaptor {
    RegularStopTimeAdaptor(TimetabledPassingTime timetabledPassingTime) {
        super(timetabledPassingTime);
    }

    @Override
    public boolean isComplete() {
        return this.hasArrivalTime() || this.hasDepartureTime();
    }

    @Override
    public boolean isConsistent() {
        return this.arrivalTime() == null || this.departureTime() == null || this.normalizedDepartureTime() >= this.normalizedArrivalTime();
    }

    @Override
    public int normalizedEarliestDepartureTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int normalizedLatestArrivalTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int normalizedDepartureTimeOrElseArrivalTime() {
        return this.hasDepartureTime() ? this.normalizedDepartureTime() : this.normalizedArrivalTime();
    }

    @Override
    public int normalizedArrivalTimeOrElseDepartureTime() {
        return this.hasArrivalTime() ? this.normalizedArrivalTime() : this.normalizedDepartureTime();
    }

    private int normalizedDepartureTime() {
        return ServiceJourneyHelper.elapsedTimeSinceMidnight(this.departureTime(), this.departureDayOffset());
    }

    private int normalizedArrivalTime() {
        return ServiceJourneyHelper.elapsedTimeSinceMidnight(this.arrivalTime(), this.arrivalDayOffset());
    }

    private boolean hasArrivalTime() {
        return this.arrivalTime() != null;
    }

    private boolean hasDepartureTime() {
        return this.departureTime() != null;
    }
}

