/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support.stoptime;

import java.math.BigInteger;
import java.time.LocalTime;
import org.opentripplanner.netex.support.stoptime.AreaStopTimeAdaptor;
import org.opentripplanner.netex.support.stoptime.RegularStopTimeAdaptor;
import org.opentripplanner.netex.support.stoptime.StopTimeAdaptor;
import org.rutebanken.netex.model.TimetabledPassingTime;

abstract sealed class AbstractStopTimeAdaptor
implements StopTimeAdaptor
permits AreaStopTimeAdaptor, RegularStopTimeAdaptor {
    private final TimetabledPassingTime timetabledPassingTime;

    protected AbstractStopTimeAdaptor(TimetabledPassingTime timetabledPassingTime) {
        this.timetabledPassingTime = timetabledPassingTime;
    }

    @Override
    public final Object timetabledPassingTimeId() {
        return this.timetabledPassingTime.getId();
    }

    @Override
    public final boolean isStopTimesIncreasing(StopTimeAdaptor next) {
        if (this instanceof RegularStopTimeAdaptor) {
            if (next instanceof RegularStopTimeAdaptor) {
                return this.isRegularStopFollowedByRegularStopValid(next);
            }
            return this.isRegularStopFollowedByAreaStopValid(next);
        }
        if (next instanceof RegularStopTimeAdaptor) {
            return this.isAreaStopFollowedByRegularStopValid(next);
        }
        return this.isAreaStopFollowedByAreaStopValid(next);
    }

    protected LocalTime arrivalTime() {
        return this.timetabledPassingTime.getArrivalTime();
    }

    protected BigInteger arrivalDayOffset() {
        return this.timetabledPassingTime.getArrivalDayOffset();
    }

    protected LocalTime latestArrivalTime() {
        return this.timetabledPassingTime.getLatestArrivalTime();
    }

    protected BigInteger latestArrivalDayOffset() {
        return this.timetabledPassingTime.getLatestArrivalDayOffset();
    }

    protected LocalTime departureTime() {
        return this.timetabledPassingTime.getDepartureTime();
    }

    protected BigInteger departureDayOffset() {
        return this.timetabledPassingTime.getDepartureDayOffset();
    }

    protected LocalTime earliestDepartureTime() {
        return this.timetabledPassingTime.getEarliestDepartureTime();
    }

    protected BigInteger earliestDepartureDayOffset() {
        return this.timetabledPassingTime.getEarliestDepartureDayOffset();
    }

    private boolean isRegularStopFollowedByRegularStopValid(StopTimeAdaptor next) {
        return this.normalizedDepartureTimeOrElseArrivalTime() <= next.normalizedArrivalTimeOrElseDepartureTime();
    }

    private boolean isAreaStopFollowedByAreaStopValid(StopTimeAdaptor next) {
        int earliestDepartureTime = this.normalizedEarliestDepartureTime();
        int nextEarliestDepartureTime = next.normalizedEarliestDepartureTime();
        int latestArrivalTime = this.normalizedLatestArrivalTime();
        int nextLatestArrivalTime = next.normalizedLatestArrivalTime();
        return earliestDepartureTime <= nextEarliestDepartureTime && latestArrivalTime <= nextLatestArrivalTime;
    }

    private boolean isRegularStopFollowedByAreaStopValid(StopTimeAdaptor next) {
        return this.normalizedDepartureTimeOrElseArrivalTime() <= next.normalizedEarliestDepartureTime();
    }

    private boolean isAreaStopFollowedByRegularStopValid(StopTimeAdaptor next) {
        return this.normalizedLatestArrivalTime() <= next.normalizedArrivalTimeOrElseDepartureTime();
    }
}

