/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.support.stoptime.StopTimeAdaptor;
import org.rutebanken.netex.model.EntityStructure;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.JourneyPattern_VersionStructure;
import org.rutebanken.netex.model.PointInJourneyPatternRefStructure;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.StopPointInJourneyPattern;
import org.rutebanken.netex.model.TimetabledPassingTime;

public class ServiceJourneyInfo {
    private final JourneyPattern_VersionStructure journeyPattern;
    private final ServiceJourney serviceJourney;
    private final NetexEntityIndexReadOnlyView netexEntityIndex;

    public ServiceJourneyInfo(ServiceJourney serviceJourney, NetexEntityIndexReadOnlyView netexEntityIndex) {
        this.serviceJourney = serviceJourney;
        this.netexEntityIndex = netexEntityIndex;
        this.journeyPattern = (JourneyPattern_VersionStructure)netexEntityIndex.getJourneyPatternsById().lookup(this.patternId());
    }

    public List<StopTimeAdaptor> orderedTimetabledPassingTimeInfos() {
        Map<TimetabledPassingTime, Boolean> stopFlexibility = this.stopFlexibility();
        Map<String, Integer> stopPointIdToOrder = this.journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().stream().collect(Collectors.toMap(EntityStructure::getId, point -> point.getOrder().intValueExact()));
        return this.serviceJourney.getPassingTimes().getTimetabledPassingTime().stream().sorted(Comparator.comparing(timetabledPassingTime -> (Integer)stopPointIdToOrder.get(ServiceJourneyInfo.stopPointId(timetabledPassingTime)))).map(timetabledPassingTime -> StopTimeAdaptor.of(timetabledPassingTime, (Boolean)stopFlexibility.get(timetabledPassingTime))).toList();
    }

    private Map<TimetabledPassingTime, Boolean> stopFlexibility() {
        Map<String, String> scheduledStopPointIdByStopPointId = this.scheduledStopPointIdByStopPointId();
        return this.serviceJourney.getPassingTimes().getTimetabledPassingTime().stream().collect(Collectors.toMap(timetabledPassingTime -> timetabledPassingTime, timetabledPassingTime -> this.netexEntityIndex.getFlexibleStopPlaceByStopPointRef().containsKey((String)scheduledStopPointIdByStopPointId.get(((PointInJourneyPatternRefStructure)timetabledPassingTime.getPointInJourneyPatternRef().getValue()).getRef()))));
    }

    private static String stopPointId(TimetabledPassingTime timetabledPassingTime) {
        return ((PointInJourneyPatternRefStructure)timetabledPassingTime.getPointInJourneyPatternRef().getValue()).getRef();
    }

    private Map<String, String> scheduledStopPointIdByStopPointId() {
        return this.journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().stream().collect(Collectors.toMap(EntityStructure::getId, p -> ((ScheduledStopPointRefStructure)((StopPointInJourneyPattern)p).getScheduledStopPointRef().getValue()).getRef()));
    }

    private String patternId() {
        return ((JourneyPatternRefStructure)this.serviceJourney.getJourneyPatternRef().getValue()).getRef();
    }
}

