/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Objects;

public class ServiceJourneyHelper {
    private ServiceJourneyHelper() {
    }

    public static int elapsedTimeSinceMidnight(LocalTime time, BigInteger dayOffset) {
        return ServiceJourneyHelper.elapsedTimeSinceMidnight(time, ServiceJourneyHelper.getDayOffset(dayOffset));
    }

    private static int elapsedTimeSinceMidnight(LocalTime time, int dayOffset) {
        Objects.requireNonNull(time);
        return (int)Duration.between(LocalTime.MIDNIGHT, time).plus(Duration.ofDays(dayOffset)).toSeconds();
    }

    private static int getDayOffset(BigInteger offset) {
        return offset != null ? offset.intValueExact() : 0;
    }
}

