/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.calendar;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.calendar.OperatingDayMapper;
import org.opentripplanner.netex.mapping.support.ServiceAlterationFilter;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingDayRefStructure;

public class DatedServiceJourneyMapper {
    public static Collection<LocalDate> mapToServiceDates(Iterable<DatedServiceJourney> dsjs, ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById) {
        ArrayList<LocalDate> result = new ArrayList<LocalDate>();
        for (DatedServiceJourney dsj : dsjs) {
            if (!ServiceAlterationFilter.isRunning(dsj.getServiceAlteration())) continue;
            OperatingDay opDay = DatedServiceJourneyMapper.operatingDay(dsj, operatingDayById);
            if (opDay != null) {
                result.add(OperatingDayMapper.map(opDay));
                continue;
            }
            throw new NullPointerException("DatedServiceJourney operating-day not found. DSJ Id: " + dsj.getId());
        }
        return result;
    }

    @Nullable
    private static OperatingDay operatingDay(DatedServiceJourney dsj, ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById) {
        OperatingDayRefStructure operatingDayRef = dsj.getOperatingDayRef();
        return operatingDayRef == null ? null : (OperatingDay)operatingDayById.lookup(operatingDayRef.getRef());
    }
}

