/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.mapping.WgsCoordinateMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.rutebanken.netex.model.Parking;
import org.rutebanken.netex.model.ParkingVehicleEnumeration;

class VehicleParkingMapper {
    private final FeedScopedIdFactory idFactory;
    private static final Set<ParkingVehicleEnumeration> BICYCLE_TYPES = Set.of(ParkingVehicleEnumeration.PEDAL_CYCLE, ParkingVehicleEnumeration.E_CYCLE, ParkingVehicleEnumeration.CYCLE);
    private final DataImportIssueStore issueStore;

    VehicleParkingMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
    }

    @Nullable
    VehicleParking map(Parking parking) {
        if (parking.getTotalCapacity() == null) {
            this.issueStore.add("MissingParkingCapacity", "NeTEx Parking '%s' does not contain totalCapacity", VehicleParkingMapper.parkingDebugId(parking));
            return null;
        }
        return VehicleParking.builder().id(this.idFactory.createId(parking.getId())).name(NonLocalizedString.ofNullable(parking.getName().getValue())).coordinate(WgsCoordinateMapper.mapToDomain(parking.getCentroid())).capacity(VehicleParkingMapper.mapCapacity(parking)).bicyclePlaces(VehicleParkingMapper.hasBikes(parking)).carPlaces(!VehicleParkingMapper.hasBikes(parking)).entrance(this.mapEntrance(parking)).build();
    }

    private static String parkingDebugId(Parking parking) {
        if (parking.getId() != null) {
            return parking.getId();
        }
        if (parking.getName() != null) {
            return parking.getName().getValue();
        }
        if (parking.getCentroid() != null) {
            return parking.getCentroid().toString();
        }
        return parking.toString();
    }

    private VehicleParking.VehicleParkingEntranceCreator mapEntrance(Parking parking) {
        return builder -> builder.entranceId(this.idFactory.createId(parking.getId() + "/entrance")).coordinate(WgsCoordinateMapper.mapToDomain(parking.getCentroid())).walkAccessible(true).carAccessible(true);
    }

    private static VehicleParkingSpaces mapCapacity(Parking parking) {
        VehicleParkingSpaces.VehicleParkingSpacesBuilder builder = VehicleParkingSpaces.builder();
        int capacity = parking.getTotalCapacity().intValue();
        if (VehicleParkingMapper.hasBikes(parking)) {
            builder.bicycleSpaces(capacity);
        } else {
            builder.carSpaces(capacity);
        }
        return builder.build();
    }

    private static boolean hasBikes(Parking parking) {
        return parking.getParkingVehicleTypes().stream().anyMatch(BICYCLE_TYPES::contains);
    }
}

