/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import jakarta.xml.bind.JAXBElement;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.mapping.DirectionMapper;
import org.opentripplanner.netex.mapping.TransportModeMapper;
import org.opentripplanner.netex.mapping.TripServiceAlterationMapper;
import org.opentripplanner.netex.mapping.WheelChairMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexMainAndSubMode;
import org.opentripplanner.netex.support.JourneyPatternHelper;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.DefaultEntityById;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.rutebanken.netex.model.DirectionTypeEnumeration;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.JourneyPattern_VersionStructure;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.OperatorRefStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TripMapper.class);
    private final FeedScopedIdFactory idFactory;
    private final DataImportIssueStore issueStore;
    private final EntityById<Route> otpRouteById;
    private final ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Route> routeById;
    private final ReadOnlyHierarchicalMap<String, JourneyPattern_VersionStructure> journeyPatternsById;
    private final Map<String, FeedScopedId> serviceIds;
    private final EntityById<Operator> operatorsById;
    private final TransportModeMapper transportModeMapper = new TransportModeMapper();
    private final EntityById<Trip> mappedTrips = new DefaultEntityById<Trip>();

    TripMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore, EntityById<Operator> operatorsById, EntityById<Route> otpRouteById, ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Route> routeById, ReadOnlyHierarchicalMap<String, JourneyPattern_VersionStructure> journeyPatternsById, Map<String, FeedScopedId> serviceIds) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
        this.otpRouteById = otpRouteById;
        this.routeById = routeById;
        this.journeyPatternsById = journeyPatternsById;
        this.serviceIds = serviceIds;
        this.operatorsById = operatorsById;
    }

    @Nullable
    Trip mapServiceJourney(ServiceJourney serviceJourney, Supplier<String> headsign) {
        FeedScopedId serviceId = this.serviceIds.get(serviceJourney.getId());
        if (serviceId == null) {
            LOG.warn("Unable to map ServiceJourney, missing Route. SJ id: {}", (Object)serviceJourney.getId());
            return null;
        }
        Route route = this.resolveRoute(serviceJourney);
        if (route == null) {
            LOG.warn("Unable to map ServiceJourney, missing serviceId. SJ id: {}", (Object)serviceJourney.getId());
            return null;
        }
        FeedScopedId id = this.idFactory.createId(serviceJourney.getId());
        if (this.mappedTrips.containsKey(id)) {
            return (Trip)this.mappedTrips.get(id);
        }
        Accessibility wheelChairBoarding = WheelChairMapper.wheelchairAccessibility(serviceJourney.getAccessibilityAssessment(), Accessibility.NO_INFORMATION);
        TripBuilder builder = Trip.of(id);
        builder.withRoute(route);
        builder.withServiceId(serviceId);
        builder.withWheelchairBoarding(wheelChairBoarding);
        if (serviceJourney.getPrivateCode() != null) {
            builder.withNetexInternalPlanningCode(serviceJourney.getPrivateCode().getValue());
        }
        builder.withShortName(serviceJourney.getPublicCode());
        builder.withOperator(this.findOperator(serviceJourney));
        if (serviceJourney.getTransportMode() != null) {
            NetexMainAndSubMode transitMode = null;
            try {
                transitMode = this.transportModeMapper.map(serviceJourney.getTransportMode(), serviceJourney.getTransportSubmode());
            }
            catch (TransportModeMapper.UnsupportedModeException e) {
                this.issueStore.add("UnsupportedModeInServiceJourney", "Unsupported mode in ServiceJourney. Mode: %s, sj: %s", e.mode, serviceJourney.getId());
                return null;
            }
            builder.withMode(transitMode.mainMode());
            builder.withNetexSubmode(transitMode.subMode());
            builder.withCarsAllowed(this.transportModeMapper.mapCarsAllowed(serviceJourney.getTransportSubmode()));
        } else {
            builder.withCarsAllowed(this.transportModeMapper.mapCarsAllowed(route.getNetexSubmode()));
        }
        builder.withDirection(DirectionMapper.map(this.resolveDirectionType(serviceJourney)));
        builder.withNetexAlteration(TripServiceAlterationMapper.mapAlteration(serviceJourney.getServiceAlteration()));
        builder.withHeadsign(new NonLocalizedString(headsign.get()));
        return (Trip)builder.build();
    }

    private DirectionTypeEnumeration resolveDirectionType(ServiceJourney serviceJourney) {
        org.rutebanken.netex.model.Route netexRoute = this.lookUpNetexRoute(serviceJourney);
        if (netexRoute != null && netexRoute.getDirectionType() != null) {
            return netexRoute.getDirectionType();
        }
        return null;
    }

    private org.rutebanken.netex.model.Route lookUpNetexRoute(ServiceJourney serviceJourney) {
        JourneyPattern_VersionStructure journeyPattern;
        if (serviceJourney.getJourneyPatternRef() != null && (journeyPattern = this.journeyPatternsById.lookup(((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef())) != null && journeyPattern.getRouteRef() != null) {
            String routeRef = journeyPattern.getRouteRef().getRef();
            return this.routeById.lookup(routeRef);
        }
        return null;
    }

    private Route resolveRoute(ServiceJourney serviceJourney) {
        String lineRef = null;
        JAXBElement lineRefStruct = serviceJourney.getLineRef();
        if (lineRefStruct != null) {
            lineRef = ((LineRefStructure)lineRefStruct.getValue()).getRef();
        } else if (serviceJourney.getJourneyPatternRef() != null) {
            JourneyPattern_VersionStructure journeyPattern = this.journeyPatternsById.lookup(((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef());
            lineRef = JourneyPatternHelper.getLineFromRoute(this.routeById, journeyPattern);
        }
        Route route = (Route)this.otpRouteById.get(this.idFactory.createId(lineRef));
        if (route == null) {
            LOG.warn("Unable to link ServiceJourney to Route. ServiceJourney id: {}, Line ref: {}", (Object)serviceJourney.getId(), (Object)lineRef);
        }
        return route;
    }

    @Nullable
    private Operator findOperator(ServiceJourney serviceJourney) {
        OperatorRefStructure opeRef = serviceJourney.getOperatorRef();
        if (opeRef == null) {
            return null;
        }
        return (Operator)this.operatorsById.get(this.idFactory.createId(opeRef.getRef()));
    }
}

