/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.netex.mapping.support.NetexMainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.network.CarAccess;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.TransportSubmodeStructure;
import org.rutebanken.netex.model.WaterSubmodeEnumeration;

class TransportModeMapper {
    private static final Set<String> CARS_ALLOWED_WATER_SUBMODES = Set.of(WaterSubmodeEnumeration.NATIONAL_CAR_FERRY.value(), WaterSubmodeEnumeration.REGIONAL_CAR_FERRY.value(), WaterSubmodeEnumeration.LOCAL_CAR_FERRY.value(), WaterSubmodeEnumeration.HIGH_SPEED_VEHICLE_SERVICE.value());

    TransportModeMapper() {
    }

    public NetexMainAndSubMode map(AllVehicleModesOfTransportEnumeration netexMode, TransportSubmodeStructure submode) throws UnsupportedModeException {
        if (submode == null) {
            return new NetexMainAndSubMode(this.mapAllVehicleModesOfTransport(netexMode));
        }
        return this.getSubmodeAsString(submode);
    }

    public TransitMode mapAllVehicleModesOfTransport(AllVehicleModesOfTransportEnumeration mode) throws UnsupportedModeException {
        if (mode == null) {
            throw new UnsupportedModeException(null);
        }
        return switch (mode) {
            case AllVehicleModesOfTransportEnumeration.AIR -> TransitMode.AIRPLANE;
            case AllVehicleModesOfTransportEnumeration.BUS -> TransitMode.BUS;
            case AllVehicleModesOfTransportEnumeration.CABLEWAY -> TransitMode.GONDOLA;
            case AllVehicleModesOfTransportEnumeration.COACH -> TransitMode.COACH;
            case AllVehicleModesOfTransportEnumeration.FUNICULAR -> TransitMode.FUNICULAR;
            case AllVehicleModesOfTransportEnumeration.METRO -> TransitMode.SUBWAY;
            case AllVehicleModesOfTransportEnumeration.RAIL -> TransitMode.RAIL;
            case AllVehicleModesOfTransportEnumeration.TAXI -> TransitMode.TAXI;
            case AllVehicleModesOfTransportEnumeration.TRAM -> TransitMode.TRAM;
            case AllVehicleModesOfTransportEnumeration.WATER -> TransitMode.FERRY;
            default -> throw new UnsupportedModeException(mode);
        };
    }

    public CarAccess mapCarsAllowed(@Nullable TransportSubmodeStructure submode) {
        if (submode == null || submode.getWaterSubmode() == null) {
            return CarAccess.NOT_ALLOWED;
        }
        return this.mapCarsAllowed(submode.getWaterSubmode().value());
    }

    public CarAccess mapCarsAllowed(@Nullable SubMode otpSubmode) {
        return this.mapCarsAllowed(otpSubmode == null ? null : otpSubmode.name());
    }

    private NetexMainAndSubMode getSubmodeAsString(TransportSubmodeStructure submode) {
        if (submode.getAirSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.AIRPLANE, submode.getAirSubmode().value());
        }
        if (submode.getBusSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.BUS, submode.getBusSubmode().value());
        }
        if (submode.getTelecabinSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.GONDOLA, submode.getTelecabinSubmode().value());
        }
        if (submode.getCoachSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.COACH, submode.getCoachSubmode().value());
        }
        if (submode.getFunicularSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FUNICULAR, submode.getFunicularSubmode().value());
        }
        if (submode.getMetroSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.SUBWAY, submode.getMetroSubmode().value());
        }
        if (submode.getRailSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.RAIL, submode.getRailSubmode().value());
        }
        if (submode.getTramSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.TRAM, submode.getTramSubmode().value());
        }
        if (submode.getWaterSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FERRY, submode.getWaterSubmode().value());
        }
        if (submode.getTaxiSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.TAXI, submode.getTaxiSubmode().value());
        }
        throw new IllegalArgumentException();
    }

    private CarAccess mapCarsAllowed(@Nullable String submode) {
        return submode != null && CARS_ALLOWED_WATER_SUBMODES.contains(submode) ? CarAccess.ALLOWED : CarAccess.NOT_ALLOWED;
    }

    static class UnsupportedModeException
    extends Exception {
        final AllVehicleModesOfTransportEnumeration mode;

        public UnsupportedModeException(AllVehicleModesOfTransportEnumeration mode) {
            this.mode = mode;
        }
    }
}

