/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.NetexMainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.StopPlace;

class StopPlaceTypeMapper {
    StopPlaceTypeMapper() {
    }

    public NetexMainAndSubMode map(StopPlace stopPlace) {
        NetexMainAndSubMode submode = this.getSubmodeAsString(stopPlace);
        if (submode != null) {
            return submode;
        }
        TransitMode mode = this.mapVehicleMode(stopPlace);
        return new NetexMainAndSubMode(mode, null);
    }

    private TransitMode mapVehicleMode(StopPlace stopPlace) {
        if (stopPlace.getTransportMode() == null) {
            return null;
        }
        return switch (stopPlace.getTransportMode()) {
            default -> throw new MatchException(null, null);
            case AllVehicleModesOfTransportEnumeration.AIR -> TransitMode.AIRPLANE;
            case AllVehicleModesOfTransportEnumeration.BUS -> TransitMode.BUS;
            case AllVehicleModesOfTransportEnumeration.TROLLEY_BUS -> TransitMode.TROLLEYBUS;
            case AllVehicleModesOfTransportEnumeration.CABLEWAY -> TransitMode.GONDOLA;
            case AllVehicleModesOfTransportEnumeration.COACH -> TransitMode.COACH;
            case AllVehicleModesOfTransportEnumeration.FUNICULAR -> TransitMode.FUNICULAR;
            case AllVehicleModesOfTransportEnumeration.METRO -> TransitMode.SUBWAY;
            case AllVehicleModesOfTransportEnumeration.RAIL -> TransitMode.RAIL;
            case AllVehicleModesOfTransportEnumeration.TRAM -> TransitMode.TRAM;
            case AllVehicleModesOfTransportEnumeration.WATER, AllVehicleModesOfTransportEnumeration.FERRY -> TransitMode.FERRY;
            case AllVehicleModesOfTransportEnumeration.LIFT, AllVehicleModesOfTransportEnumeration.OTHER, AllVehicleModesOfTransportEnumeration.SNOW_AND_ICE, AllVehicleModesOfTransportEnumeration.TAXI, AllVehicleModesOfTransportEnumeration.ALL, AllVehicleModesOfTransportEnumeration.ANY_MODE, AllVehicleModesOfTransportEnumeration.INTERCITY_RAIL, AllVehicleModesOfTransportEnumeration.URBAN_RAIL, AllVehicleModesOfTransportEnumeration.SELF_DRIVE, AllVehicleModesOfTransportEnumeration.UNKNOWN -> null;
        };
    }

    private NetexMainAndSubMode getSubmodeAsString(StopPlace stopPlace) {
        if (stopPlace.getAirSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.AIRPLANE, stopPlace.getAirSubmode().value());
        }
        if (stopPlace.getBusSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.BUS, stopPlace.getBusSubmode().value());
        }
        if (stopPlace.getTelecabinSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.GONDOLA, stopPlace.getTelecabinSubmode().value());
        }
        if (stopPlace.getCoachSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.COACH, stopPlace.getCoachSubmode().value());
        }
        if (stopPlace.getFunicularSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FUNICULAR, stopPlace.getFunicularSubmode().value());
        }
        if (stopPlace.getMetroSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.SUBWAY, stopPlace.getMetroSubmode().value());
        }
        if (stopPlace.getRailSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.RAIL, stopPlace.getRailSubmode().value());
        }
        if (stopPlace.getTramSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.TRAM, stopPlace.getTramSubmode().value());
        }
        if (stopPlace.getWaterSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FERRY, stopPlace.getWaterSubmode().value());
        }
        return null;
    }
}

