/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.Multimap;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.mapping.AuthorityToAgencyMapper;
import org.opentripplanner.netex.mapping.TransportModeMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexMainAndSubMode;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Branding;
import org.opentripplanner.transit.model.organization.Operator;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.BrandingRefStructure;
import org.rutebanken.netex.model.FlexibleLine_VersionStructure;
import org.rutebanken.netex.model.GroupOfLinesRefStructure;
import org.rutebanken.netex.model.Line_VersionStructure;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.OperatorRefStructure;
import org.rutebanken.netex.model.PresentationStructure;
import org.rutebanken.netex.model.TransportOrganisationRefStructure;

class RouteMapper {
    private final DataImportIssueStore issueStore;
    private final HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();
    private final TransportModeMapper transportModeMapper = new TransportModeMapper();
    private final FeedScopedIdFactory idFactory;
    private final EntityById<Agency> agenciesById;
    private final EntityById<Operator> operatorsById;
    private final EntityById<Branding> brandingsById;
    private final Multimap<FeedScopedId, GroupOfRoutes> groupsOfLinesByRouteId;
    private final EntityById<GroupOfRoutes> groupOfRoutesById;
    private final NetexEntityIndexReadOnlyView netexIndex;
    private final AuthorityToAgencyMapper authorityMapper;
    private final Set<String> ferryIdsNotAllowedForBicycle;

    RouteMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<Agency> agenciesById, EntityById<Operator> operatorsById, EntityById<Branding> brandingsById, Multimap<FeedScopedId, GroupOfRoutes> groupsOfLinesByRouteId, EntityById<GroupOfRoutes> groupOfRoutesById, NetexEntityIndexReadOnlyView netexIndex, String timeZone, Set<String> ferryIdsNotAllowedForBicycle) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.agenciesById = agenciesById;
        this.operatorsById = operatorsById;
        this.brandingsById = brandingsById;
        this.groupsOfLinesByRouteId = groupsOfLinesByRouteId;
        this.groupOfRoutesById = groupOfRoutesById;
        this.netexIndex = netexIndex;
        this.authorityMapper = new AuthorityToAgencyMapper(idFactory, timeZone);
        this.ferryIdsNotAllowedForBicycle = ferryIdsNotAllowedForBicycle;
    }

    Route mapRoute(Line_VersionStructure line) {
        NetexMainAndSubMode mode;
        RouteBuilder builder = Route.of(this.idFactory.createId(line.getId()));
        builder.getGroupsOfRoutes().addAll(this.getGroupOfRoutes(line));
        builder.withAgency(this.findOrCreateAuthority(line));
        builder.withOperator(this.findOperator(line));
        builder.withBranding(this.findBranding(line));
        NonLocalizedString longName = NonLocalizedString.ofNullable(line.getName().getValue());
        builder.withLongName(longName);
        builder.withShortName(line.getPublicCode());
        try {
            mode = this.transportModeMapper.map(line.getTransportMode(), line.getTransportSubmode());
        }
        catch (TransportModeMapper.UnsupportedModeException e) {
            this.issueStore.add("UnsupportedModeInLine", "Unsupported mode in Line. Mode: %s, line: %s", e.mode, line.getId());
            return null;
        }
        builder.withMode(mode.mainMode());
        builder.withNetexSubmode(mode.subMode());
        if (line instanceof FlexibleLine_VersionStructure) {
            builder.withFlexibleLineType(((FlexibleLine_VersionStructure)line).getFlexibleLineType().value());
        }
        if (line.getPresentation() != null) {
            PresentationStructure presentation = line.getPresentation();
            if (presentation.getColour() != null) {
                builder.withColor(this.hexBinaryAdapter.marshal(presentation.getColour()));
            }
            if (presentation.getTextColour() != null) {
                builder.withTextColor(this.hexBinaryAdapter.marshal(presentation.getTextColour()));
            }
        }
        if (line.getTransportMode().equals((Object)AllVehicleModesOfTransportEnumeration.WATER)) {
            if (this.ferryIdsNotAllowedForBicycle.contains(line.getId())) {
                builder.withBikesAllowed(BikeAccess.NOT_ALLOWED);
            } else {
                builder.withBikesAllowed(BikeAccess.ALLOWED);
            }
        }
        return (Route)builder.build();
    }

    private Collection<GroupOfRoutes> getGroupOfRoutes(Line_VersionStructure line) {
        FeedScopedId groupOfRoutesId;
        FeedScopedId lineId = this.idFactory.createId(line.getId());
        HashSet<GroupOfRoutes> groupsOfRoutes = new HashSet<GroupOfRoutes>(this.groupsOfLinesByRouteId.get((Object)lineId));
        GroupOfLinesRefStructure representedByGroupRef = line.getRepresentedByGroupRef();
        if (representedByGroupRef != null && this.groupOfRoutesById.containsKey(groupOfRoutesId = this.idFactory.createId(representedByGroupRef.getRef()))) {
            groupsOfRoutes.add((GroupOfRoutes)this.groupOfRoutesById.get(groupOfRoutesId));
        }
        return groupsOfRoutes;
    }

    private Agency findOrCreateAuthority(Line_VersionStructure line) {
        GroupOfLinesRefStructure representedByGroupRef = line.getRepresentedByGroupRef();
        Agency agency = null;
        if (representedByGroupRef != null) {
            String groupRef = representedByGroupRef.getRef();
            Network network = this.netexIndex.lookupNetworkForLine(groupRef);
            if (network != null) {
                String orgRef = ((TransportOrganisationRefStructure)network.getTransportOrganisationRef().getValue()).getRef();
                agency = (Agency)this.agenciesById.get(this.idFactory.createId(orgRef));
            }
        } else if (line.getAuthorityRef() != null) {
            agency = (Agency)this.agenciesById.get(this.idFactory.createId(line.getAuthorityRef().getRef()));
        }
        return agency != null ? agency : this.createOrGetDummyAgency(line);
    }

    private Agency createOrGetDummyAgency(Line_VersionStructure line) {
        this.issueStore.add("LineWithoutAuthority", "No authority found for %s", line.getId());
        Agency agency = (Agency)this.agenciesById.get(this.idFactory.createId(this.authorityMapper.dummyAgencyId()));
        if (agency == null) {
            agency = this.authorityMapper.createDummyAgency();
            this.agenciesById.add(agency);
        }
        return agency;
    }

    @Nullable
    private Operator findOperator(Line_VersionStructure line) {
        OperatorRefStructure opeRef = line.getOperatorRef();
        if (opeRef == null) {
            return null;
        }
        return (Operator)this.operatorsById.get(this.idFactory.createId(opeRef.getRef()));
    }

    @Nullable
    private Branding findBranding(Line_VersionStructure line) {
        BrandingRefStructure brandingRef = line.getBrandingRef();
        if (brandingRef == null) {
            return null;
        }
        return (Branding)this.brandingsById.get(this.idFactory.createId(brandingRef.getRef()));
    }
}

