/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.DefaultEntityById;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class NoticeMapper {
    private final FeedScopedIdFactory idFactory;
    private final EntityById<Notice> cache = new DefaultEntityById<Notice>();

    NoticeMapper(FeedScopedIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    Notice map(org.rutebanken.netex.model.Notice netexNotice) {
        FeedScopedId id = this.idFactory.createId(netexNotice.getId());
        Notice otpNotice = (Notice)this.cache.get(id);
        if (otpNotice == null) {
            otpNotice = (Notice)Notice.of(id).withPublicCode(netexNotice.getPublicCode()).withText(netexNotice.getText().getValue()).build();
            this.cache.add(otpNotice);
        }
        return otpNotice;
    }
}

