/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.mapping.NoticeMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.timetable.Trip;
import org.rutebanken.netex.model.NoticeAssignment;
import org.rutebanken.netex.model.PointInJourneyPatternRefStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.TimetabledPassingTime;

class NoticeAssignmentMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final Multimap<String, TimetabledPassingTime> passingTimeByStopPointId = ArrayListMultimap.create();
    private final ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Notice> noticesById;
    private final EntityById<Route> routesById;
    private final EntityById<Trip> tripsById;
    private final Map<String, StopTime> stopTimesByNetexId;
    private final NoticeMapper noticeMapper;

    NoticeAssignmentMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, Collection<ServiceJourney> serviceJourneys, ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Notice> noticesById, EntityById<Route> routesById, EntityById<Trip> tripsById, Map<String, StopTime> stopTimesByNetexId) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.noticeMapper = new NoticeMapper(idFactory);
        this.noticesById = noticesById;
        this.routesById = routesById;
        this.tripsById = tripsById;
        this.stopTimesByNetexId = stopTimesByNetexId;
        for (ServiceJourney sj : serviceJourneys) {
            for (TimetabledPassingTime it : sj.getPassingTimes().getTimetabledPassingTime()) {
                this.passingTimeByStopPointId.put((Object)((PointInJourneyPatternRefStructure)it.getPointInJourneyPatternRef().getValue()).getRef(), (Object)it);
            }
        }
    }

    Multimap<AbstractTransitEntity, Notice> map(NoticeAssignment noticeAssignment) {
        ArrayListMultimap noticiesByEntity = ArrayListMultimap.create();
        String noticedObjectId = noticeAssignment.getNoticedObjectRef().getRef();
        Notice otpNotice = this.getOrMapNotice(noticeAssignment);
        if (otpNotice == null) {
            this.issueStore.add("NoticeAssignmentWithoutNotice", "Notice in notice assignment is missing for assignment %s", noticeAssignment);
            return noticiesByEntity;
        }
        Collection times = this.passingTimeByStopPointId.get((Object)noticedObjectId);
        if (times != null && !times.isEmpty()) {
            for (TimetabledPassingTime time : times) {
                this.addStopTimeNotice((Multimap<AbstractTransitEntity, Notice>)noticiesByEntity, time.getId(), otpNotice);
            }
        } else if (this.stopTimesByNetexId.containsKey(noticedObjectId)) {
            this.addStopTimeNotice((Multimap<AbstractTransitEntity, Notice>)noticiesByEntity, noticedObjectId, otpNotice);
        } else {
            FeedScopedId otpId = this.idFactory.createId(noticedObjectId);
            if (this.routesById.containsKey(otpId)) {
                noticiesByEntity.put((Object)((AbstractTransitEntity)this.routesById.get(otpId)), (Object)otpNotice);
            } else if (this.tripsById.containsKey(otpId)) {
                noticiesByEntity.put((Object)((AbstractTransitEntity)this.tripsById.get(otpId)), (Object)otpNotice);
            } else {
                this.issueStore.add("NoticeAssignmentWithUnknownEntity", "Could not map notice assignment %s for element with id %s", noticeAssignment.getId(), noticedObjectId);
            }
        }
        return noticiesByEntity;
    }

    @Nullable
    private Notice getOrMapNotice(NoticeAssignment assignment) {
        org.rutebanken.netex.model.Notice notice = assignment.getNotice() != null ? assignment.getNotice() : this.noticesById.lookup(assignment.getNoticeRef().getRef());
        return notice == null ? null : this.noticeMapper.map(notice);
    }

    private void addStopTimeNotice(Multimap<AbstractTransitEntity, Notice> map, String stopTimeId, Notice notice) {
        StopTime stopTime = this.stopTimesByNetexId.get(stopTimeId);
        if (stopTime == null) {
            this.issueStore.add("NoticeAssigmentWithoutStopTime", "NoticeAssigment mapping failed, StopTime not found. StopTime id: %s", stopTimeId);
            return;
        }
        map.put((Object)stopTime.getId(), (Object)notice);
    }
}

