/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.mapping.WgsCoordinateMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.MultiModalStationBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.rutebanken.netex.model.MultilingualString;
import org.rutebanken.netex.model.StopPlace;

class MultiModalStationMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;

    public MultiModalStationMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
    }

    @Nullable
    MultiModalStation map(StopPlace stopPlace, Collection<Station> childStations) {
        MultiModalStationBuilder multiModalStation = MultiModalStation.of(this.idFactory.createId(stopPlace.getId())).withChildStations(childStations).withName(NonLocalizedString.ofNullable(stopPlace.getName(), MultilingualString::getValue, "N/A"));
        WgsCoordinate coordinate = WgsCoordinateMapper.mapToDomain(stopPlace.getCentroid());
        if (coordinate == null) {
            this.issueStore.add("MultiModalStationWithoutCoordinates", "MultiModal station %s does not contain any coordinates.", multiModalStation.getId());
            return null;
        }
        multiModalStation.withCoordinate(coordinate);
        return (MultiModalStation)multiModalStation.build();
    }
}

