/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.netex.mapping.OpenGisMapper;
import org.opentripplanner.netex.mapping.TransportModeMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStopBuilder;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.SiteRepositoryBuilder;
import org.rutebanken.netex.model.FlexibleArea;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.KeyListStructure;
import org.rutebanken.netex.model.KeyValueStructure;
import org.rutebanken.netex.model.MultilingualString;

class FlexStopsMapper {
    private static final String FLEXIBLE_STOP_AREA_TYPE_KEY = "FlexibleStopAreaType";
    private static final String UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE = "UnrestrictedPublicTransportAreas";
    private final FeedScopedIdFactory idFactory;
    private final HashGridSpatialIndex<RegularStop> stopsSpatialIndex;
    private final SiteRepositoryBuilder siteRepositoryBuilder;
    private final DataImportIssueStore issueStore;
    private final TransportModeMapper transportModeMapper = new TransportModeMapper();

    FlexStopsMapper(FeedScopedIdFactory idFactory, Collection<RegularStop> stops, SiteRepositoryBuilder siteRepositoryBuilder, DataImportIssueStore issueStore) {
        this.idFactory = idFactory;
        this.stopsSpatialIndex = new HashGridSpatialIndex();
        for (RegularStop stop : stops) {
            Envelope env = new Envelope(stop.getCoordinate().asJtsCoordinate());
            this.stopsSpatialIndex.insert(env, (Object)stop);
        }
        this.siteRepositoryBuilder = siteRepositoryBuilder;
        this.issueStore = issueStore;
    }

    StopLocation map(FlexibleStopPlace flexibleStopPlace) {
        ArrayList<AbstractTransitEntity> stops = new ArrayList<AbstractTransitEntity>();
        TransitMode flexibleStopTransitMode = this.mapTransitMode(flexibleStopPlace);
        List areas = flexibleStopPlace.getAreas().getFlexibleAreaOrFlexibleAreaRefOrHailAndRideArea();
        ArrayList<Geometry> areaGeometries = new ArrayList<Geometry>();
        for (Object area : areas) {
            if (!(area instanceof FlexibleArea)) {
                this.issueStore.add(Issue.issue("UnsupportedFlexibleStopPlaceAreaType", "FlexibleStopPlace %s contains an unsupported area %s.", flexibleStopPlace.getId(), area));
                continue;
            }
            FlexibleArea flexibleArea = (FlexibleArea)area;
            Geometry flexibleAreaGeometry = this.mapGeometry(flexibleArea);
            areaGeometries.add(flexibleAreaGeometry);
            if (this.shouldAddStopsFromArea(flexibleArea, flexibleStopPlace)) {
                stops.addAll(this.findStopsInFlexArea(flexibleArea, flexibleAreaGeometry, flexibleStopTransitMode));
                continue;
            }
            AreaStop areaStop = this.mapFlexArea(flexibleArea, flexibleAreaGeometry, flexibleStopPlace.getName().getValue());
            if (areaStop == null) continue;
            stops.add(areaStop);
        }
        if (stops.isEmpty()) {
            return null;
        }
        GroupStopBuilder builder = this.siteRepositoryBuilder.groupStop(this.idFactory.createId(flexibleStopPlace.getId())).withName(new NonLocalizedString(flexibleStopPlace.getName().getValue())).withEncompassingAreaGeometries(areaGeometries);
        stops.forEach(builder::addLocation);
        return (StopLocation)builder.build();
    }

    AreaStop mapFlexArea(FlexibleArea area, Geometry geometry, String backupName) {
        if (geometry == null) {
            return null;
        }
        MultilingualString areaName = area.getName();
        return (AreaStop)this.siteRepositoryBuilder.areaStop(this.idFactory.createId(area.getId())).withName(new NonLocalizedString(areaName != null ? areaName.getValue() : backupName)).withGeometry(geometry).build();
    }

    List<RegularStop> findStopsInFlexArea(FlexibleArea area, @Nullable Geometry geometry, @Nullable TransitMode flexibleStopTransitMode) {
        if (geometry == null || flexibleStopTransitMode == null) {
            return List.of();
        }
        List<RegularStop> stops = this.stopsSpatialIndex.query(geometry.getEnvelopeInternal()).stream().filter(stop -> flexibleStopTransitMode == stop.getVehicleType()).filter(stop -> geometry.contains((Geometry)stop.getGeometry())).toList();
        if (stops.isEmpty()) {
            this.issueStore.add(Issue.issue("MissingStopsInUnrestrictedPublicTransportAreas", "FlexibleArea %s with type UnrestrictedPublicTransportAreas does not contain any regular stop.", area.getId()));
            return List.of();
        }
        return stops;
    }

    private Geometry mapGeometry(FlexibleArea area) {
        try {
            return OpenGisMapper.mapGeometry(area.getPolygon());
        }
        catch (Exception e) {
            this.issueStore.add(Issue.issue("InvalidFlexAreaGeometry", "FlexibleArea %s has an invalid geometry.", area.getId()));
            return null;
        }
    }

    @Nullable
    private TransitMode mapTransitMode(FlexibleStopPlace flexibleStopPlace) {
        try {
            return this.transportModeMapper.mapAllVehicleModesOfTransport(flexibleStopPlace.getTransportMode());
        }
        catch (TransportModeMapper.UnsupportedModeException e) {
            return null;
        }
    }

    private boolean shouldAddStopsFromArea(FlexibleArea flexibleArea, FlexibleStopPlace parentStop) {
        String flexibleAreaType = FlexStopsMapper.getFlexibleStopAreaType(flexibleArea.getKeyList());
        String parentStopType = FlexStopsMapper.getFlexibleStopAreaType(parentStop.getKeyList());
        if (UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE.equals(flexibleAreaType)) {
            return true;
        }
        return UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE.equals(parentStopType) && flexibleAreaType == null;
    }

    private static String getFlexibleStopAreaType(KeyListStructure keyListStructure) {
        String flexibleStopAreaType = null;
        if (keyListStructure != null) {
            for (KeyValueStructure k : keyListStructure.getKeyValue()) {
                if (!k.getKey().equals(FLEXIBLE_STOP_AREA_TYPE_KEY)) continue;
                flexibleStopAreaType = k.getValue();
                break;
            }
        }
        return flexibleStopAreaType;
    }
}

