/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.MultilingualStringMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexObjectDecorator;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.AgencyBuilder;
import org.opentripplanner.utils.lang.StringUtils;
import org.rutebanken.netex.model.Authority;

class AuthorityToAgencyMapper {
    private final FeedScopedIdFactory idFactory;
    private final String timeZone;
    private final String dummyAgencyId;

    AuthorityToAgencyMapper(FeedScopedIdFactory idFactory, String timeZone) {
        this.idFactory = idFactory;
        this.timeZone = timeZone;
        this.dummyAgencyId = "Dummy-" + timeZone;
    }

    Agency mapAuthorityToAgency(Authority source) {
        String name = MultilingualStringMapper.nullableValueOf(source.getName());
        String shortName = MultilingualStringMapper.nullableValueOf(source.getShortName());
        String agencyName = StringUtils.hasValue((String)name) ? name : shortName;
        AgencyBuilder target = Agency.of(this.idFactory.createId(source.getId())).withName(agencyName).withTimezone(this.timeZone);
        NetexObjectDecorator.withOptional(source.getContactDetails(), c -> {
            target.withUrl(c.getUrl());
            target.withPhone(c.getPhone());
        });
        return (Agency)target.build();
    }

    Agency createDummyAgency() {
        return (Agency)Agency.of(this.idFactory.createId(this.dummyAgencyId)).withName("N/A").withTimezone(this.timeZone).withUrl("N/A").withPhone("N/A").build();
    }

    String dummyAgencyId() {
        return this.dummyAgencyId;
    }
}

