/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.opentripplanner.netex.loader.parser.NoticeParser;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.Interchange_VersionStructure;
import org.rutebanken.netex.model.JourneyInterchangesInFrame_RelStructure;
import org.rutebanken.netex.model.Journey_VersionStructure;
import org.rutebanken.netex.model.JourneysInFrame_RelStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.Timetable_VersionFrameStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeTableFrameParser
extends NetexParser<Timetable_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTableFrameParser.class);
    private final List<ServiceJourney> serviceJourneys = new ArrayList<ServiceJourney>();
    private final List<DatedServiceJourney> datedServiceJourneys = new ArrayList<DatedServiceJourney>();
    private final List<ServiceJourneyInterchange> serviceJourneyInterchanges = new ArrayList<ServiceJourneyInterchange>();
    private final NoticeParser noticeParser = new NoticeParser();

    TimeTableFrameParser() {
    }

    @Override
    void parse(Timetable_VersionFrameStructure frame) {
        this.parseJourneys(frame.getVehicleJourneys());
        this.parseInterchanges(frame.getJourneyInterchanges());
        this.noticeParser.parseNotices(frame.getNotices());
        this.noticeParser.parseNoticeAssignments(frame.getNoticeAssignments());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getNetworkView());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getLineView());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getOperatorView());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getAccessibilityAssessment());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getBookingTimes());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getCoupledJourneys());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getDefaultInterchanges());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getFlexibleServiceProperties());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getFrequencyGroups());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfServices());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getInterchangeRules());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getJourneyAccountingRef());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getJourneyAccountings());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getJourneyMeetings());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getJourneyPartCouples());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getServiceCalendarFrameRef());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getServiceFacilitySets());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getTimeDemandTypes());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getTimeDemandTypeAssignments());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getTimingLinkGroups());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getTrainNumbers());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getTypesOfService());
        TimeTableFrameParser.warnOnMissingMapping(LOG, frame.getVehicleTypes());
        TimeTableFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntityIndex netexIndex) {
        netexIndex.serviceJourneyById.addAll(this.serviceJourneys);
        netexIndex.datedServiceJourneys.addAll(this.datedServiceJourneys);
        netexIndex.serviceJourneyInterchangeById.addAll(this.serviceJourneyInterchanges);
        this.noticeParser.setResultOnIndex(netexIndex);
    }

    private void parseJourneys(JourneysInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        for (Journey_VersionStructure it : element.getVehicleJourneyOrDatedVehicleJourneyOrNormalDatedVehicleJourney()) {
            if (it instanceof ServiceJourney) {
                ServiceJourney serviceJourney = (ServiceJourney)it;
                this.serviceJourneys.add(serviceJourney);
                continue;
            }
            if (it instanceof DatedServiceJourney) {
                DatedServiceJourney datedServiceJourney = (DatedServiceJourney)it;
                this.datedServiceJourneys.add(datedServiceJourney);
                continue;
            }
            TimeTableFrameParser.warnOnMissingMapping(LOG, it);
        }
    }

    private void parseInterchanges(JourneyInterchangesInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        List list = element.getServiceJourneyPatternInterchangeOrServiceJourneyInterchange();
        for (Interchange_VersionStructure it : list) {
            if (it instanceof ServiceJourneyInterchange) {
                ServiceJourneyInterchange serviceJourneyInterchange = (ServiceJourneyInterchange)it;
                this.serviceJourneyInterchanges.add(serviceJourneyInterchange);
                continue;
            }
            TimeTableFrameParser.warnOnMissingMapping(LOG, it);
        }
    }
}

