/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.netex.config.IgnorableFeature;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.opentripplanner.netex.support.JAXBUtils;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.Parking;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.Quays_RelStructure;
import org.rutebanken.netex.model.Site_VersionFrameStructure;
import org.rutebanken.netex.model.Site_VersionStructure;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.TariffZone;
import org.rutebanken.netex.model.TariffZone_VersionStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.rutebanken.netex.model.Zone_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SiteFrameParser
extends NetexParser<Site_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(SiteFrameParser.class);
    private final Collection<FlexibleStopPlace> flexibleStopPlaces = new ArrayList<FlexibleStopPlace>();
    private final Collection<GroupOfStopPlaces> groupsOfStopPlaces = new ArrayList<GroupOfStopPlaces>();
    private final Collection<StopPlace> multiModalStopPlaces = new ArrayList<StopPlace>();
    private final Collection<StopPlace> stopPlaces = new ArrayList<StopPlace>();
    private final Collection<TariffZone_VersionStructure> tariffZones = new ArrayList<TariffZone_VersionStructure>();
    private final Collection<Quay> quays = new ArrayList<Quay>();
    private final Collection<Parking> parkings = new ArrayList<Parking>(0);
    private final Set<IgnorableFeature> ignoredFeatures;

    SiteFrameParser(Set<IgnorableFeature> ignoredFeatures) {
        this.ignoredFeatures = ignoredFeatures;
    }

    @Override
    public void parse(Site_VersionFrameStructure frame) {
        if (frame.getStopPlaces() != null) {
            this.parseStopPlaces(frame.getStopPlaces().getStopPlace_());
        }
        if (frame.getGroupsOfStopPlaces() != null) {
            this.parseGroupsOfStopPlaces(frame.getGroupsOfStopPlaces().getGroupOfStopPlaces());
        }
        if (OTPFeature.FlexRouting.isOn() && frame.getFlexibleStopPlaces() != null) {
            this.parseFlexibleStopPlaces(frame.getFlexibleStopPlaces().getFlexibleStopPlace());
        }
        if (frame.getTariffZones() != null) {
            this.parseTariffZones(frame.getTariffZones().getTariffZone());
        }
        if (!this.ignoredFeatures.contains((Object)IgnorableFeature.PARKING) && frame.getParkings() != null) {
            this.parseParkings(frame.getParkings().getParking());
        }
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getAccesses());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getAddresses());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getCountries());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getCheckConstraints());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getCheckConstraintDelays());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getCheckConstraintThroughputs());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getNavigationPaths());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getPathJunctions());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getPathLinks());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getPointsOfInterest());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getPointOfInterestClassifications());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getPointOfInterestClassificationHierarchies());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getSiteFacilitySets());
        SiteFrameParser.warnOnMissingMapping(LOG, frame.getTopographicPlaces());
        SiteFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntityIndex netexIndex) {
        netexIndex.flexibleStopPlaceById.addAll(this.flexibleStopPlaces);
        netexIndex.groupOfStopPlacesById.addAll(this.groupsOfStopPlaces);
        netexIndex.multiModalStopPlaceById.addAll(this.multiModalStopPlaces);
        netexIndex.stopPlaceById.addAll(this.stopPlaces);
        netexIndex.tariffZonesById.addAll(this.tariffZones);
        netexIndex.quayById.addAll(this.quays);
        netexIndex.parkings.addAll(this.parkings);
    }

    private void parseFlexibleStopPlaces(Collection<FlexibleStopPlace> flexibleStopPlacesList) {
        this.flexibleStopPlaces.addAll(flexibleStopPlacesList);
    }

    private void parseGroupsOfStopPlaces(Collection<GroupOfStopPlaces> groupsOfStopPlacesList) {
        this.groupsOfStopPlaces.addAll(groupsOfStopPlacesList);
    }

    private void parseParkings(List<Parking> parking) {
        this.parkings.addAll(parking);
    }

    private void parseStopPlaces(List<JAXBElement<? extends Site_VersionStructure>> stopPlaceList) {
        for (JAXBElement<? extends Site_VersionStructure> jaxBStopPlace : stopPlaceList) {
            StopPlace stopPlace = (StopPlace)jaxBStopPlace.getValue();
            if (this.isMultiModalStopPlace(stopPlace)) {
                this.multiModalStopPlaces.add(stopPlace);
                continue;
            }
            this.stopPlaces.add(stopPlace);
            this.parseQuays(stopPlace.getQuays());
        }
    }

    private void parseTariffZones(List<JAXBElement<? extends Zone_VersionStructure>> tariffZoneList) {
        for (JAXBElement<? extends Zone_VersionStructure> tariffZone : tariffZoneList) {
            if (!(tariffZone.getValue() instanceof TariffZone)) continue;
            this.tariffZones.add((TariffZone_VersionStructure)((TariffZone)tariffZone.getValue()));
        }
    }

    private void parseQuays(Quays_RelStructure quayRefOrQuay) {
        if (quayRefOrQuay == null) {
            return;
        }
        JAXBUtils.forEachJAXBElementValue(Quay.class, quayRefOrQuay.getQuayRefOrQuay(), this.quays::add);
    }

    private boolean isMultiModalStopPlace(StopPlace stopPlace) {
        return stopPlace.getKeyList() != null && stopPlace.getKeyList().getKeyValue().stream().anyMatch(keyValueStructure -> keyValueStructure.getKey().equals("IS_PARENT_STOP_PLACE") && keyValueStructure.getValue().equals("true"));
    }
}

