/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.Branding;
import org.rutebanken.netex.model.Operator;
import org.rutebanken.netex.model.Organisation_VersionStructure;
import org.rutebanken.netex.model.OrganisationsInFrame_RelStructure;
import org.rutebanken.netex.model.ResourceFrame_VersionFrameStructure;
import org.rutebanken.netex.model.TypesOfValueInFrame_RelStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceFrameParser
extends NetexParser<ResourceFrame_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFrameParser.class);
    private final Collection<Authority> authorities = new ArrayList<Authority>();
    private final Collection<Operator> operators = new ArrayList<Operator>();
    private final Collection<Branding> brandings = new ArrayList<Branding>();

    ResourceFrameParser() {
    }

    @Override
    void parse(ResourceFrame_VersionFrameStructure frame) {
        this.parseOrganization(frame.getOrganisations());
        this.parseTypesOfValue(frame.getTypesOfValue());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getBlacklists());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getControlCentres());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getDataSources());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getEquipments());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfEntities());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfOperators());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getOperationalContexts());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getResponsibilitySets());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getSchematicMaps());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getVehicles());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getVehicleEquipmentProfiles());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getVehicleModels());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getVehicleTypes());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getWhitelists());
        ResourceFrameParser.warnOnMissingMapping(LOG, frame.getZones());
        ResourceFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntityIndex netexIndex) {
        netexIndex.authoritiesById.addAll(this.authorities);
        netexIndex.operatorsById.addAll(this.operators);
        netexIndex.brandingById.addAll(this.brandings);
    }

    private void parseOrganization(OrganisationsInFrame_RelStructure elements) {
        if (elements != null) {
            for (JAXBElement e : elements.getOrganisation_()) {
                this.parseOrganization((Organisation_VersionStructure)e.getValue());
            }
        }
    }

    private void parseOrganization(Organisation_VersionStructure element) {
        if (element instanceof Authority) {
            Authority authority = (Authority)element;
            this.authorities.add(authority);
        } else if (element instanceof Operator) {
            Operator operator = (Operator)element;
            this.operators.add(operator);
        } else {
            ResourceFrameParser.warnOnMissingMapping(LOG, element);
        }
    }

    private void parseTypesOfValue(TypesOfValueInFrame_RelStructure element) {
        if (element == null || element.getValueSetOrTypeOfValue() == null) {
            return;
        }
        for (JAXBElement e : element.getValueSetOrTypeOfValue()) {
            if (e.getValue() instanceof Branding) {
                this.parseBranding((Branding)e.getValue());
                continue;
            }
            ResourceFrameParser.warnOnMissingMapping(LOG, e);
        }
    }

    private void parseBranding(Branding branding) {
        this.brandings.add(branding);
    }
}

