/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.index.hierarchy;

import java.time.LocalDateTime;
import org.opentripplanner.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.EntityInVersionStructure;

class ValidOnDate<T extends EntityInVersionStructure> {
    private final T entity;
    private final LocalDateTime time;

    ValidOnDate(T entity, LocalDateTime timeLimit) {
        this.entity = entity;
        this.time = NetexVersionHelper.firstValidDateTime(entity.getValidBetween(), timeLimit);
    }

    T entity() {
        return this.entity;
    }

    boolean isValid() {
        return this.time != null;
    }

    boolean bestVersion(ValidOnDate<T> other) {
        if (this.time.isBefore(other.time)) {
            return true;
        }
        if (other.time.isBefore(this.time)) {
            return false;
        }
        return NetexVersionHelper.versionOf(this.entity) > NetexVersionHelper.versionOf(other.entity);
    }
}

