/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.index.hierarchy;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;

public abstract class AbstractHierarchicalMap<K, V>
implements ReadOnlyHierarchicalMap<K, V> {
    private final AbstractHierarchicalMap<K, V> parent;

    AbstractHierarchicalMap(AbstractHierarchicalMap<K, V> parent) {
        this.parent = parent;
    }

    @Override
    public V lookup(K key) {
        return this.localContainsKey(key) || this.isRoot() ? this.localGet(key) : this.parent.lookup(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.localContainsKey(key) || this.parentContainsKey(key);
    }

    public int size() {
        return this.localSize() + (this.isRoot() ? 0 : this.parent.localSize());
    }

    public void validate(HMapValidationRule<K, V> rule, Consumer<DataImportIssue> warnMsgConsumer) {
        ArrayList discardKeys = new ArrayList();
        for (Object key : this.localKeys()) {
            V value = this.localGet(key);
            HMapValidationRule.Status status = rule.validate(value);
            if (status == HMapValidationRule.Status.DISCARD) {
                discardKeys.add(key);
            }
            if (status == HMapValidationRule.Status.OK) continue;
            warnMsgConsumer.accept(rule.logMessage(key, value));
        }
        discardKeys.forEach(this::localRemove);
    }

    public void validate(Supplier<HMapValidationRule<K, V>> ruleSupplier, Consumer<DataImportIssue> warnMsgConsumer) {
        ArrayList discardKeys = new ArrayList();
        for (Object key : this.localKeys()) {
            V value = this.localGet(key);
            HMapValidationRule rule = ruleSupplier.get();
            HMapValidationRule.Status status = rule.validate(value);
            if (status == HMapValidationRule.Status.DISCARD) {
                discardKeys.add(key);
            }
            if (status == HMapValidationRule.Status.OK) continue;
            warnMsgConsumer.accept(rule.logMessage(key, value));
        }
        discardKeys.forEach(this::localRemove);
    }

    public AbstractHierarchicalMap<K, V> parent() {
        return this.parent;
    }

    public String toString() {
        return "size = " + this.size();
    }

    protected abstract int localSize();

    abstract V localGet(K var1);

    abstract boolean localContainsKey(K var1);

    abstract void localRemove(K var1);

    private boolean isRoot() {
        return this.parent == null;
    }

    private boolean parentContainsKey(K key) {
        return this.parent != null && this.parent.containsKey(key);
    }
}

