/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.configure;

import java.util.ArrayList;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.ConfiguredCompositeDataSource;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.netex.loader.NetexDataSourceHierarchy;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TimetableRepository;

public class NetexConfigure {
    private final BuildConfig buildParams;

    public NetexConfigure(BuildConfig builderParams) {
        this.buildParams = builderParams;
    }

    public NetexModule createNetexModule(Iterable<ConfiguredCompositeDataSource<NetexFeedParameters>> netexSources, TimetableRepository timetableRepository, VehicleParkingRepository parkingRepsitory, Graph graph, DataImportIssueStore issueStore) {
        ArrayList<NetexBundle> netexBundles = new ArrayList<NetexBundle>();
        for (ConfiguredCompositeDataSource<NetexFeedParameters> it : netexSources) {
            OtpTransitServiceBuilder transitServiceBuilder = new OtpTransitServiceBuilder(timetableRepository.getSiteRepository(), issueStore);
            netexBundles.add(this.netexBundle(transitServiceBuilder, it));
        }
        return new NetexModule(graph, timetableRepository, parkingRepsitory, issueStore, this.buildParams.getSubwayAccessTimeSeconds(), this.buildParams.getTransitServicePeriod(), netexBundles);
    }

    public NetexBundle netexBundle(OtpTransitServiceBuilder transitServiceBuilder, ConfiguredCompositeDataSource<NetexFeedParameters> configuredDataSource) {
        CompositeDataSource source = configuredDataSource.dataSource();
        NetexFeedParameters config = (NetexFeedParameters)configuredDataSource.config();
        return new NetexBundle(config.feedId(), source, this.hierarchy(source, config), transitServiceBuilder, config.ferryIdsNotAllowedForBicycle(), this.buildParams.transitRouteToStationCentroid(), this.buildParams.maxStopToShapeSnapDistance, config.noTransfersOnIsolatedStops(), config.ignoredFeatures());
    }

    private NetexDataSourceHierarchy hierarchy(CompositeDataSource source, NetexFeedParameters params) {
        return new NetexDataSourceHierarchy(source).prepare(params.ignoreFilePattern(), params.sharedFilePattern(), params.sharedGroupFilePattern(), params.groupFilePattern());
    }
}

