/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex;

import java.util.List;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.AddTransitEntitiesToGraph;
import org.opentripplanner.graph_builder.module.ValidateAndInterpolateStopTimesForEachTrip;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingHelper;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TimetableRepository;

public class NetexModule
implements GraphBuilderModule {
    private final int subwayAccessTime;
    private final Graph graph;
    private final TimetableRepository timetableRepository;
    private final VehicleParkingRepository parkingRepository;
    private final DataImportIssueStore issueStore;
    private final ServiceDateInterval transitPeriodLimit;
    private final List<NetexBundle> netexBundles;

    public NetexModule(Graph graph, TimetableRepository timetableRepository, VehicleParkingRepository parkingRepository, DataImportIssueStore issueStore, int subwayAccessTime, ServiceDateInterval transitPeriodLimit, List<NetexBundle> netexBundles) {
        this.graph = graph;
        this.timetableRepository = timetableRepository;
        this.parkingRepository = parkingRepository;
        this.issueStore = issueStore;
        this.subwayAccessTime = subwayAccessTime;
        this.transitPeriodLimit = transitPeriodLimit;
        this.netexBundles = netexBundles;
    }

    @Override
    public void buildGraph() {
        try {
            CalendarServiceData calendarServiceData = new CalendarServiceData();
            boolean hasActiveTransit = false;
            for (NetexBundle netexBundle : this.netexBundles) {
                netexBundle.checkInputs();
                OtpTransitServiceBuilder transitBuilder = netexBundle.loadBundle(this.graph.deduplicator, this.issueStore);
                transitBuilder.limitServiceDays(this.transitPeriodLimit);
                for (TripOnServiceDate tripOnServiceDate : transitBuilder.getTripOnServiceDates().values()) {
                    this.timetableRepository.addTripOnServiceDate(tripOnServiceDate);
                }
                calendarServiceData.add(transitBuilder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    transitBuilder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(transitBuilder, this.issueStore));
                }
                this.validateStopTimesForEachTrip(transitBuilder.getStopTimesSortedByTrip());
                OtpTransitService otpService = transitBuilder.build();
                hasActiveTransit = hasActiveTransit || otpService.hasActiveTransit();
                this.timetableRepository.addOperators(otpService.getAllOperators());
                this.timetableRepository.addNoticeAssignments(otpService.getNoticeAssignments());
                this.timetableRepository.addScheduledStopPointMapping(otpService.stopsByScheduledStopPoint());
                AddTransitEntitiesToGraph.addToGraph(otpService, this.subwayAccessTime, this.graph, this.timetableRepository);
                this.timetableRepository.validateTimeZones();
                List<VehicleParking> lots = transitBuilder.vehicleParkings();
                this.parkingRepository.updateVehicleParking(lots, List.of());
                VehicleParkingHelper linker = new VehicleParkingHelper(this.graph);
                lots.forEach(linker::linkVehicleParkingToGraph);
            }
            this.timetableRepository.updateCalendarServiceData(hasActiveTransit, calendarServiceData, this.issueStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateStopTimesForEachTrip(TripStopTimes stopTimesByTrip) {
        new ValidateAndInterpolateStopTimesForEachTrip(stopTimesByTrip, false, this.issueStore).run();
    }

    @Override
    public void checkInputs() {
        this.netexBundles.forEach(NetexBundle::checkInputs);
    }
}

