/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex;

import jakarta.xml.bind.JAXBException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.config.IgnorableFeature;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.GroupEntries;
import org.opentripplanner.netex.loader.NetexDataSourceHierarchy;
import org.opentripplanner.netex.loader.NetexXmlParser;
import org.opentripplanner.netex.loader.parser.NetexDocumentParser;
import org.opentripplanner.netex.mapping.NetexMapper;
import org.opentripplanner.netex.validation.Validator;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.rutebanken.netex.model.PublicationDeliveryStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetexBundle
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NetexBundle.class);
    private final CompositeDataSource source;
    private final NetexDataSourceHierarchy hierarchy;
    private final OtpTransitServiceBuilder transitBuilder;
    private final String feedId;
    private final Set<String> ferryIdsNotAllowedForBicycle;
    private final Collection<FeedScopedId> routeToCentroidStopPlaceIds;
    private final double maxStopToShapeSnapDistance;
    private final boolean noTransfersOnIsolatedStops;
    private final Set<IgnorableFeature> ignoredFeatures;
    private NetexEntityIndex index = new NetexEntityIndex();
    private DataImportIssueStore issueStore;
    private NetexMapper mapper;
    private NetexXmlParser xmlParser;

    public NetexBundle(String feedId, CompositeDataSource source, NetexDataSourceHierarchy hierarchy, OtpTransitServiceBuilder transitBuilder, Set<String> ferryIdsNotAllowedForBicycle, Collection<FeedScopedId> routeToCentroidStopPlaceIds, double maxStopToShapeSnapDistance, boolean noTransfersOnIsolatedStops, Set<IgnorableFeature> ignorableFeatures) {
        this.feedId = feedId;
        this.source = source;
        this.hierarchy = hierarchy;
        this.transitBuilder = transitBuilder;
        this.ferryIdsNotAllowedForBicycle = ferryIdsNotAllowedForBicycle;
        this.routeToCentroidStopPlaceIds = Set.copyOf(routeToCentroidStopPlaceIds);
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
        this.noTransfersOnIsolatedStops = noTransfersOnIsolatedStops;
        this.ignoredFeatures = Set.copyOf(ignorableFeatures);
    }

    public OtpTransitServiceBuilder loadBundle(Deduplicator deduplicator, DataImportIssueStore issueStore) {
        LOG.info("Reading {}", (Object)this.hierarchy.description());
        this.issueStore = issueStore;
        this.xmlParser = new NetexXmlParser();
        this.mapper = new NetexMapper(this.transitBuilder, this.feedId, deduplicator, issueStore, this.ferryIdsNotAllowedForBicycle, this.routeToCentroidStopPlaceIds, this.maxStopToShapeSnapDistance, this.noTransfersOnIsolatedStops);
        this.loadFileEntries();
        return this.transitBuilder;
    }

    public void checkInputs() {
        if (!this.source.exists()) {
            throw new RuntimeException("NeTEx " + this.source.path() + " does not exist.");
        }
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    private void loadFileEntries() {
        this.loadFilesThenMapToTimetableRepository("shared file", this.hierarchy.sharedEntries());
        for (GroupEntries group : this.hierarchy.groups()) {
            LOG.info("reading group {}", (Object)group.name());
            this.scopeInputData(() -> {
                this.loadFilesThenMapToTimetableRepository("shared group file", group.sharedEntries());
                for (DataSource entry : group.independentEntries()) {
                    this.scopeInputData(() -> this.loadFilesThenMapToTimetableRepository("group file", List.of(entry)));
                }
            });
        }
        this.mapper.finishUp();
        NetexDocumentParser.finishUp();
    }

    private void scopeInputData(Runnable task) {
        this.index = this.index.push();
        this.mapper = this.mapper.push();
        task.run();
        this.mapper = this.mapper.pop();
        this.index = this.index.pop();
    }

    private void loadFilesThenMapToTimetableRepository(String fileDescription, Iterable<DataSource> entries) {
        for (DataSource entry : entries) {
            this.loadSingeFileEntry(fileDescription, entry);
        }
        Validator.validate(this.index, this.issueStore);
        this.mapper.mapNetexToOtp(this.index.readOnlyView());
    }

    private void loadSingeFileEntry(String fileDescription, DataSource entry) {
        try {
            LOG.info("reading entity {}: {}", (Object)fileDescription, (Object)entry.name());
            this.issueStore.startProcessingSource(entry.name());
            PublicationDeliveryStructure doc = this.xmlParser.parseXmlDoc(entry.asInputStream());
            NetexDocumentParser.parseAndPopulateIndex(this.index, doc, this.ignoredFeatures);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.issueStore.stopProcessingSource();
        }
    }
}

