/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.projectinfo;

import java.io.Serializable;
import org.opentripplanner.model.projectinfo.GraphFileHeader;
import org.opentripplanner.model.projectinfo.MavenProjectVersion;
import org.opentripplanner.model.projectinfo.OtpProjectInfoParser;
import org.opentripplanner.model.projectinfo.VersionControlInfo;

public class OtpProjectInfo
implements Serializable {
    static final String UNKNOWN = "UNKNOWN";
    private static final OtpProjectInfo INSTANCE = OtpProjectInfoParser.loadFromProperties();
    public final MavenProjectVersion version;
    public final GraphFileHeader graphFileHeaderInfo;
    public final VersionControlInfo versionControl;
    public String otpConfigVersion;
    public String buildConfigVersion;
    public String routerConfigVersion;

    OtpProjectInfo() {
        this("0.0.0-ParseFailure", new GraphFileHeader(), new VersionControlInfo());
    }

    public OtpProjectInfo(String version, GraphFileHeader graphFileHeaderInfo, VersionControlInfo versionControl) {
        this.version = MavenProjectVersion.parse(version);
        this.graphFileHeaderInfo = graphFileHeaderInfo;
        this.versionControl = versionControl;
    }

    public static OtpProjectInfo projectInfo() {
        return INSTANCE;
    }

    public long getUID() {
        return this.hashCode();
    }

    public boolean matchesRunningOTPInstance(GraphFileHeader graphFileHeader) {
        if (graphFileHeader.isUnknown()) {
            return true;
        }
        if (this.graphFileHeaderInfo.isUnknown()) {
            return true;
        }
        return this.graphFileHeaderInfo.equals(graphFileHeader);
    }

    public String toString() {
        return "OTP " + this.getVersionString();
    }

    public String getVersionString() {
        String format = "Version: %s, ser.ver.id: %s, commit: %s, branch: %s";
        return String.format(format, this.version.version, this.getOtpSerializationVersionId(), this.versionControl.commit, this.versionControl.branch);
    }

    public boolean sameVersion(OtpProjectInfo other) {
        return this.version.sameVersion(other.version);
    }

    public String getOtpSerializationVersionId() {
        return this.graphFileHeaderInfo.otpSerializationVersionId();
    }
}

