/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.walkstep;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.walkstep.AbsoluteDirection;
import org.opentripplanner.model.plan.walkstep.RelativeDirection;
import org.opentripplanner.model.plan.walkstep.WalkStepBuilder;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class WalkStep {
    private final WgsCoordinate startLocation;
    private final double distance;
    private final RelativeDirection relativeDirection;
    private final I18NString directionText;
    private final AbsoluteDirection absoluteDirection;
    private final Set<StreetNote> streetNotes;
    private final boolean area;
    private final boolean nameIsDerived;
    private final double angle;
    private final boolean walkingBike;
    private final String highwayExit;
    private final Entrance entrance;
    private final ElevationProfile elevationProfile;
    private final boolean stayOn;
    private final List<Edge> edges;

    WalkStep(WgsCoordinate startLocation, RelativeDirection relativeDirection, AbsoluteDirection absoluteDirection, I18NString directionText, Set<StreetNote> streetNotes, String highwayExit, Entrance entrance, ElevationProfile elevationProfile, boolean nameIsDerived, boolean walkingBike, boolean area, boolean stayOn, double angle, double distance, List<Edge> edges) {
        this.distance = distance;
        this.relativeDirection = Objects.requireNonNull(relativeDirection);
        this.absoluteDirection = absoluteDirection;
        this.directionText = directionText;
        this.streetNotes = Set.copyOf((Collection)Objects.requireNonNull(streetNotes));
        this.startLocation = Objects.requireNonNull(startLocation);
        this.nameIsDerived = nameIsDerived;
        this.angle = DoubleUtils.roundTo2Decimals((double)angle);
        this.walkingBike = walkingBike;
        this.area = area;
        this.highwayExit = highwayExit;
        this.entrance = entrance;
        this.elevationProfile = elevationProfile;
        this.stayOn = stayOn;
        this.edges = List.copyOf((Collection)Objects.requireNonNull(edges));
    }

    public ElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public Set<StreetNote> getStreetNotes() {
        return this.streetNotes;
    }

    public double getDistance() {
        return this.distance;
    }

    public RelativeDirection getRelativeDirection() {
        return this.relativeDirection;
    }

    public I18NString getDirectionText() {
        return this.directionText;
    }

    public Optional<AbsoluteDirection> getAbsoluteDirection() {
        return Optional.ofNullable(this.absoluteDirection);
    }

    public Optional<String> highwayExit() {
        return Optional.ofNullable(this.highwayExit);
    }

    public Optional<Entrance> entrance() {
        return Optional.ofNullable(this.entrance);
    }

    public boolean isStayOn() {
        return this.stayOn;
    }

    public boolean getArea() {
        return this.area;
    }

    public boolean nameIsDerived() {
        return this.nameIsDerived;
    }

    public WgsCoordinate getStartLocation() {
        return this.startLocation;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isWalkingBike() {
        return this.walkingBike;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public static WalkStepBuilder builder() {
        return new WalkStepBuilder();
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addEnum("absoluteDirection", (Enum)this.absoluteDirection).addEnum("relativeDirection", (Enum)this.relativeDirection).addStr("streetName", this.directionText.toString()).addNum("distance", (Number)this.distance).toString();
    }
}

