/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.paging.cursor;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.token.Token;
import org.opentripplanner.framework.token.TokenBuilder;
import org.opentripplanner.framework.token.TokenSchema;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.cursor.DeduplicationPageCut;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.model.plan.paging.cursor.PageType;
import org.opentripplanner.utils.lang.StringUtils;

final class PageCursorSerializer {
    private static final byte VERSION_ONE = 1;
    private static final byte VERSION_TWO = 2;
    private static final String TYPE_FIELD = "Type";
    private static final String EDT_FIELD = "EDT";
    private static final String LAT_FIELD = "LAT";
    private static final String SEARCH_WINDOW_FIELD = "SW";
    private static final String SORT_ORDER_FIELD = "SortOrder";
    private static final String CUT_ON_STREET_FIELD = "cutOnStreet";
    private static final String CUT_DEPARTURE_TIME_FIELD = "cutDepartureTime";
    private static final String CUT_ARRIVAL_TIME_FIELD = "cutArrivalTime";
    private static final String CUT_N_TRANSFERS_FIELD = "cutTx";
    private static final String CUT_COST_FIELD = "cutCost";
    private static final String GENERALIZED_COST_MAX_LIMIT = "generalizedCostMaxLimit";
    private static final TokenSchema SCHEMA_TOKEN = TokenSchema.ofVersion(1).addEnum("Type").addTimeInstant("EDT").addTimeInstant("LAT").addDuration("SW").addEnum("SortOrder").addBoolean("cutOnStreet").addTimeInstant("cutDepartureTime").addTimeInstant("cutArrivalTime").addInt("cutTx").addInt("cutCost").newVersion().addInt("generalizedCostMaxLimit").build();

    private PageCursorSerializer() {
    }

    @Nullable
    public static String encode(PageCursor cursor) {
        TokenBuilder tokenBuilder = SCHEMA_TOKEN.encode().withEnum(TYPE_FIELD, cursor.type()).withTimeInstant(EDT_FIELD, cursor.earliestDepartureTime()).withTimeInstant(LAT_FIELD, cursor.latestArrivalTime()).withDuration(SEARCH_WINDOW_FIELD, cursor.searchWindow()).withEnum(SORT_ORDER_FIELD, cursor.originalSortOrder());
        if (cursor.containsItineraryPageCut()) {
            ItinerarySortKey cut = cursor.itineraryPageCut();
            tokenBuilder.withBoolean(CUT_ON_STREET_FIELD, cut.isStreetOnly()).withTimeInstant(CUT_DEPARTURE_TIME_FIELD, cut.startTimeAsInstant()).withTimeInstant(CUT_ARRIVAL_TIME_FIELD, cut.endTimeAsInstant()).withInt(CUT_N_TRANSFERS_FIELD, cut.numberOfTransfers()).withInt(CUT_COST_FIELD, cut.generalizedCostIncludingPenalty().toSeconds());
        }
        if (cursor.containsGeneralizedCostMaxLimit()) {
            tokenBuilder.withInt(GENERALIZED_COST_MAX_LIMIT, cursor.generalizedCostMaxLimit().toSeconds());
        }
        return tokenBuilder.build();
    }

    @Nullable
    public static PageCursor decode(String cursor) {
        if (StringUtils.hasNoValue((String)cursor)) {
            return null;
        }
        try {
            OptionalInt cost;
            DeduplicationPageCut itineraryPageCut = null;
            Token token = SCHEMA_TOKEN.decode(cursor);
            PageType type = token.getEnum(TYPE_FIELD, PageType.class).orElseThrow();
            Instant edt = token.getTimeInstant(EDT_FIELD).orElse(null);
            Instant lat = token.getTimeInstant(LAT_FIELD).orElse(null);
            Duration searchWindow = token.getDuration(SEARCH_WINDOW_FIELD).orElseThrow();
            SortOrder originalSortOrder = token.getEnum(SORT_ORDER_FIELD, SortOrder.class).orElseThrow();
            Optional<Instant> cutDepartureTime = token.getTimeInstant(CUT_DEPARTURE_TIME_FIELD);
            if (cutDepartureTime.isPresent()) {
                itineraryPageCut = new DeduplicationPageCut(cutDepartureTime.get(), token.getTimeInstant(CUT_ARRIVAL_TIME_FIELD).orElseThrow(), Cost.costOfSeconds(token.getInt(CUT_COST_FIELD).orElseThrow()), token.getInt(CUT_N_TRANSFERS_FIELD).orElseThrow(), token.getBoolean(CUT_ON_STREET_FIELD).orElseThrow());
            }
            Cost generalizedCostMaxLimit = null;
            if (token.version() >= 2 && (cost = token.getInt(GENERALIZED_COST_MAX_LIMIT)).isPresent()) {
                generalizedCostMaxLimit = Cost.costOfSeconds(cost.getAsInt());
            }
            return new PageCursor(type, originalSortOrder, edt, lat, searchWindow, itineraryPageCut, generalizedCostMaxLimit);
        }
        catch (Exception e) {
            String details = e.getMessage();
            String message = "Unable to decode page cursor: '" + cursor + "'.";
            if (StringUtils.hasValue((String)details)) {
                message = message + " Details: " + details;
            }
            throw new IllegalArgumentException(message, e);
        }
    }
}

