/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.paging.cursor;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.model.plan.paging.cursor.PageCursorInput;
import org.opentripplanner.model.plan.paging.cursor.PageType;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class PageCursorFactory {
    private static final Duration SEARCH_WINDOW_END_EXCLUSIVITY_TIME_ADDITION = Duration.ofMinutes(1L);
    private final SortOrder sortOrder;
    private final Duration newSearchWindow;
    private PageType currentPageType;
    private Instant currentEdt = null;
    private Instant currentLat = null;
    private Duration currentSearchWindow = null;
    private boolean wholeSearchWindowUsed = true;
    private ItinerarySortKey itineraryPageCut = null;
    private PageCursorInput pageCursorInput = null;
    private Instant firstSearchLatestItineraryDeparture = null;
    private PageCursor nextCursor = null;
    private PageCursor prevCursor = null;

    public PageCursorFactory(SortOrder sortOrder, Duration newSearchWindow) {
        this.sortOrder = sortOrder;
        this.newSearchWindow = newSearchWindow;
    }

    public PageCursorFactory withOriginalSearch(@Nullable PageType pageType, @Nullable Instant firstItineraryResultDeparture, Instant edt, Instant lat, Duration searchWindow) {
        this.currentPageType = pageType == null ? PageCursorFactory.resolvePageTypeForTheFirstSearch(this.sortOrder) : pageType;
        this.firstSearchLatestItineraryDeparture = this.resolveFirstSearchLatestItineraryDeparture(pageType, firstItineraryResultDeparture, edt);
        this.currentEdt = edt;
        this.currentLat = lat;
        this.currentSearchWindow = searchWindow;
        return this;
    }

    public PageCursorFactory withPageCursorInput(PageCursorInput pageCursorInput) {
        this.pageCursorInput = pageCursorInput;
        if (pageCursorInput.pageCut() != null) {
            this.wholeSearchWindowUsed = false;
            this.itineraryPageCut = pageCursorInput.pageCut();
        }
        return this;
    }

    @Nullable
    public PageCursor previousPageCursor() {
        this.createPageCursors();
        return this.prevCursor;
    }

    @Nullable
    public PageCursor nextPageCursor() {
        this.createPageCursors();
        return this.nextCursor;
    }

    public String toString() {
        return ToStringBuilder.of(PageCursorFactory.class).addEnum("sortOrder", (Enum)this.sortOrder).addEnum("currentPageType", (Enum)this.currentPageType).addDateTime("currentEdt", this.currentEdt).addDateTime("currentLat", this.currentLat).addDuration("currentSearchWindow", this.currentSearchWindow).addDuration("newSearchWindow", this.newSearchWindow).addBoolIfTrue("searchWindowCropped", Boolean.valueOf(!this.wholeSearchWindowUsed)).addObj("pageCursorFactoryParams", (Object)this.pageCursorInput).addObj("nextCursor", (Object)this.nextCursor).addObj("prevCursor", (Object)this.prevCursor).toString();
    }

    private static PageType resolvePageTypeForTheFirstSearch(SortOrder sortOrder) {
        return sortOrder.isSortedByAscendingArrivalTime() ? PageType.NEXT_PAGE : PageType.PREVIOUS_PAGE;
    }

    private Instant resolveFirstSearchLatestItineraryDeparture(@Nullable PageType pageType, @Nullable Instant firstItineraryResultDeparture, Instant edt) {
        if (pageType == null && PageCursorFactory.resolvePageTypeForTheFirstSearch(this.sortOrder) == PageType.PREVIOUS_PAGE) {
            if (firstItineraryResultDeparture != null) {
                return firstItineraryResultDeparture;
            }
            return edt;
        }
        return null;
    }

    private void createPageCursors() {
        Instant nextEdt;
        Instant prevEdt;
        if (this.currentEdt == null || this.nextCursor != null || this.prevCursor != null) {
            return;
        }
        if (this.wholeSearchWindowUsed) {
            prevEdt = this.edtBeforeNewSw();
            nextEdt = this.edtAfterUsedSw();
        } else if (this.currentPageType == PageType.NEXT_PAGE) {
            prevEdt = this.edtBeforeNewSw();
            nextEdt = this.pageCursorInput.earliestRemovedDeparture();
        } else {
            prevEdt = this.pageCursorInput.latestRemovedDeparture().minus(this.newSearchWindow).plus(SEARCH_WINDOW_END_EXCLUSIVITY_TIME_ADDITION);
            nextEdt = this.edtAfterUsedSw();
        }
        Cost generalizedCostMaxLimit = this.pageCursorInput.generalizedCostMaxLimit();
        this.prevCursor = new PageCursor(PageType.PREVIOUS_PAGE, this.sortOrder, prevEdt, this.currentLat, this.newSearchWindow, this.itineraryPageCut, generalizedCostMaxLimit);
        this.nextCursor = new PageCursor(PageType.NEXT_PAGE, this.sortOrder, nextEdt, null, this.newSearchWindow, this.itineraryPageCut, generalizedCostMaxLimit);
    }

    private Instant edtBeforeNewSw() {
        return this.currentEdt.minus(this.newSearchWindow);
    }

    private Instant edtAfterUsedSw() {
        Instant edtFromLatestItineraryDeparture;
        Instant defaultEdt = this.currentEdt.plus(this.currentSearchWindow);
        if (this.firstSearchLatestItineraryDeparture != null && (edtFromLatestItineraryDeparture = this.firstSearchLatestItineraryDeparture.plus(SEARCH_WINDOW_END_EXCLUSIVITY_TIME_ADDITION)).isBefore(defaultEdt)) {
            return edtFromLatestItineraryDeparture;
        }
        return defaultEdt;
    }
}

