/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.paging.cursor;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.ItinerarySortKey;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.cursor.PageCursorSerializer;
import org.opentripplanner.model.plan.paging.cursor.PageType;
import org.opentripplanner.utils.collection.ListSection;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public record PageCursor(PageType type, SortOrder originalSortOrder, @Nullable Instant earliestDepartureTime, @Nullable Instant latestArrivalTime, Duration searchWindow, @Nullable ItinerarySortKey itineraryPageCut, @Nullable Cost generalizedCostMaxLimit) {
    public boolean containsItineraryPageCut() {
        return this.itineraryPageCut != null;
    }

    public boolean containsGeneralizedCostMaxLimit() {
        return this.generalizedCostMaxLimit != null;
    }

    @Nullable
    public String encode() {
        return PageCursorSerializer.encode(this);
    }

    @Nullable
    public static PageCursor decode(String cursor) {
        return PageCursorSerializer.decode(cursor);
    }

    public ListSection cropItinerariesAt() {
        if (this.originalSortOrder().isSortedByAscendingArrivalTime()) {
            return switch (this.type) {
                default -> throw new MatchException(null, null);
                case PageType.NEXT_PAGE -> ListSection.TAIL;
                case PageType.PREVIOUS_PAGE -> ListSection.HEAD;
            };
        }
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case PageType.NEXT_PAGE -> ListSection.HEAD;
            case PageType.PREVIOUS_PAGE -> ListSection.TAIL;
        };
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(PageCursor.class).addEnum("type", (Enum)this.type).addEnum("sortOrder", (Enum)this.originalSortOrder).addDateTime("edt", this.earliestDepartureTime).addDateTime("lat", this.latestArrivalTime).addDuration("searchWindow", this.searchWindow).addObj("generalizedCostMaxLimit", (Object)this.generalizedCostMaxLimit).addObjOp("itineraryPageCut", (Object)this.itineraryPageCut, ItinerarySortKey::keyAsString).toString();
    }
}

