/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.paging;

import java.time.Duration;
import java.time.Instant;
import java.util.List;

public final class PagingSearchWindowAdjuster {
    private final Duration minSearchWindow;
    private final Duration maxSearchWindow;
    private final int[] pagingSearchWindowAdjustments;

    public PagingSearchWindowAdjuster(Duration minSearchWindow, Duration maxSearchWindow, List<Duration> pagingSearchWindowAdjustments) {
        this.minSearchWindow = minSearchWindow;
        this.maxSearchWindow = maxSearchWindow;
        this.pagingSearchWindowAdjustments = pagingSearchWindowAdjustments.stream().mapToInt(d -> (int)d.toMinutes()).toArray();
    }

    public Duration decreaseSearchWindow(Duration searchWindowUsed, Instant searchWindowStartTime, Instant rmItineraryDepartureTime, boolean cropSearchWindowTail) {
        Duration searchWindowSlice = cropSearchWindowTail ? Duration.between(searchWindowStartTime, rmItineraryDepartureTime) : Duration.between(rmItineraryDepartureTime, searchWindowStartTime.plus(searchWindowUsed));
        return this.normalizeSearchWindow((int)searchWindowSlice.getSeconds());
    }

    public Duration increaseOrKeepSearchWindow(Duration searchWindowUsed, int nRequestedItineraries, int nActualItinerariesFound) {
        if (nActualItinerariesFound >= nRequestedItineraries) {
            return searchWindowUsed;
        }
        if (nActualItinerariesFound < this.pagingSearchWindowAdjustments.length) {
            return this.normalizeSearchWindow((int)searchWindowUsed.getSeconds() + 60 * this.pagingSearchWindowAdjustments[nActualItinerariesFound]);
        }
        return searchWindowUsed;
    }

    static int ceiling(int value, int step) {
        if (value < 0) {
            return value / step * step;
        }
        return (value + step - 1) / step * step;
    }

    Duration normalizeSearchWindow(int seconds) {
        if ((long)seconds < this.minSearchWindow.getSeconds()) {
            return this.minSearchWindow;
        }
        if ((long)seconds > this.maxSearchWindow.getSeconds()) {
            return this.maxSearchWindow;
        }
        int minutes = seconds / 60;
        if (minutes <= 240) {
            return Duration.ofMinutes(PagingSearchWindowAdjuster.ceiling(minutes, 10));
        }
        return Duration.ofMinutes(PagingSearchWindowAdjuster.ceiling(minutes, 30));
    }
}

