/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.legreference;

import java.time.LocalDate;
import java.time.ZoneId;
import javax.annotation.Nullable;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.plan.leg.LegConstructionSupport;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLegBuilder;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.routing.algorithm.mapping.AlertToLegMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ScheduledTransitLegReference(FeedScopedId tripId, LocalDate serviceDate, int fromStopPositionInPattern, int toStopPositionInPattern, FeedScopedId fromStopId, FeedScopedId toStopId, FeedScopedId tripOnServiceDateId) implements LegReference
{
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledTransitLegReference.class);

    public ScheduledTransitLegReference {
        if (tripId != null && tripOnServiceDateId != null) {
            throw new IllegalArgumentException("ScheduledTransitLegReference cannot refer to both a Trip id " + String.valueOf(tripId) + " and a TripOnServiceDate id " + String.valueOf(tripOnServiceDateId));
        }
    }

    @Override
    @Nullable
    public ScheduledTransitLeg getLeg(TransitService transitService) {
        Trip trip;
        TripOnServiceDate tripOnServiceDate = null;
        if (this.tripOnServiceDateId != null) {
            tripOnServiceDate = transitService.getTripOnServiceDate(this.tripOnServiceDateId);
            if (tripOnServiceDate == null) {
                this.logInvalidLegRef("trip on service date '{}' not found", this.tripOnServiceDateId);
                return null;
            }
            if (!tripOnServiceDate.getServiceDate().equals(this.serviceDate)) {
                this.logInvalidLegRef("trip on service date '{}' does not run on service date {}", this.tripOnServiceDateId, this.serviceDate);
                return null;
            }
            trip = tripOnServiceDate.getTrip();
        } else {
            trip = transitService.getTrip(this.tripId);
        }
        if (trip == null) {
            this.logInvalidLegRef("trip '{}' not found", this.tripId);
            return null;
        }
        TripPattern tripPattern = transitService.findPattern(trip, this.serviceDate);
        if (tripPattern == null) {
            this.logInvalidLegRef("trip pattern not found for trip '{}' and service date {}", trip.getId(), this.serviceDate);
            return null;
        }
        int numStops = tripPattern.numberOfStops();
        if (this.fromStopPositionInPattern >= numStops || this.toStopPositionInPattern >= numStops) {
            this.logInvalidLegRef("Invalid transit leg reference: boarding stop {} or alighting stop {} is out of range in trip '{}' and service date {} ({} stops in trip pattern) ", this.fromStopPositionInPattern, this.toStopPositionInPattern, trip.getId(), this.serviceDate, numStops);
            return null;
        }
        if (!this.matchReferencedStopInPattern(tripPattern, this.fromStopPositionInPattern, this.fromStopId, transitService) || !this.matchReferencedStopInPattern(tripPattern, this.toStopPositionInPattern, this.toStopId, transitService)) {
            return null;
        }
        Timetable timetable = transitService.findTimetable(tripPattern, this.serviceDate);
        TripTimes tripTimes = timetable.getTripTimes(trip);
        if (tripTimes == null) {
            this.logInvalidLegRef("trip times not found for trip '{}' and service date {}", trip.getId(), this.serviceDate);
            return null;
        }
        if (!transitService.getServiceCodesRunningForDate(this.serviceDate).contains(tripTimes.getServiceCode())) {
            this.logInvalidLegRef("the trip '{}' does not run on service date {}", trip.getId(), this.serviceDate);
            return null;
        }
        ZoneId timeZone = transitService.getTimeZone();
        int boardingTime = tripTimes.getDepartureTime(this.fromStopPositionInPattern);
        int alightingTime = tripTimes.getArrivalTime(this.toStopPositionInPattern);
        ScheduledTransitLeg leg = ((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)new ScheduledTransitLegBuilder().withTripTimes(tripTimes)).withTripPattern(tripPattern)).withBoardStopIndexInPattern(this.fromStopPositionInPattern)).withAlightStopIndexInPattern(this.toStopPositionInPattern)).withStartTime(ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate, (ZoneId)timeZone, (int)boardingTime))).withEndTime(ServiceDateUtils.toZonedDateTime((LocalDate)this.serviceDate, (ZoneId)timeZone, (int)alightingTime))).withServiceDate(this.serviceDate)).withTripOnServiceDate(tripOnServiceDate)).withZoneId(timeZone)).withDistanceMeters(LegConstructionSupport.computeDistanceMeters(tripPattern, this.fromStopPositionInPattern, this.toStopPositionInPattern))).withGeneralizedCost(0)).build();
        return (ScheduledTransitLeg)new AlertToLegMapper(transitService.getTransitAlertService(), transitService::findMultiModalStation).decorateWithAlerts(leg, false);
    }

    private boolean matchReferencedStopInPattern(TripPattern tripPattern, int stopPosition, FeedScopedId stopId, TransitService transitService) {
        if (stopId == null) {
            return true;
        }
        StopLocation stopLocationInPattern = tripPattern.getStops().get(stopPosition);
        if (stopId.equals(stopLocationInPattern.getId())) {
            return true;
        }
        StopLocation stopLocationInLegReference = transitService.getStopLocation(stopId);
        if (stopLocationInLegReference == null || stopLocationInPattern.getParentStation() == null || !stopLocationInPattern.getParentStation().equals(stopLocationInLegReference.getParentStation())) {
            LOG.info("Invalid transit leg reference: The referenced stop at position {} with id '{}' does not match the stop id '{}' in trip '{}' and service date {}", new Object[]{stopPosition, stopId, stopLocationInPattern.getId(), this.tripId, this.serviceDate});
            return false;
        }
        LOG.info("Transit leg reference with modified stop id within the same station: The referenced stop at position {} with id '{}' does not match the stop id '{}' in trip {} and service date {}", new Object[]{stopPosition, stopId, stopLocationInPattern.getId(), this.tripId, this.serviceDate});
        return true;
    }

    private void logInvalidLegRef(String message, Object ... args) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Invalid transit leg reference: " + message + " for " + String.valueOf(this), args);
        }
    }
}

