/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.legreference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.legreference.LegReferenceType;
import org.opentripplanner.model.plan.legreference.ScheduledTransitLegReference;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegReferenceSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(LegReferenceSerializer.class);

    private LegReferenceSerializer() {
    }

    @Nullable
    public static String encode(LegReference legReference) {
        String string;
        if (legReference == null) {
            return null;
        }
        LegReferenceType typeEnum = LegReferenceType.forClass(legReference.getClass()).orElseThrow(() -> new IllegalArgumentException("Unknown LegReference type"));
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        try {
            LegReferenceSerializer.writeEnum(typeEnum, out);
            typeEnum.getSerializer().write(legReference, out);
            out.flush();
            string = Base64.getUrlEncoder().encodeToString(buf.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Failed to encode leg reference", (Throwable)e);
                return null;
            }
        }
        out.close();
        return string;
    }

    @Nullable
    public static LegReference decode(String legReference) {
        LegReference legReference2;
        byte[] serializedLegReference;
        if (legReference == null) {
            return null;
        }
        try {
            serializedLegReference = Base64.getUrlDecoder().decode(legReference);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unable to decode leg reference (invalid base64 encoding): '{}'", (Object)legReference, (Object)e);
            return null;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(serializedLegReference);
        ObjectInputStream in = new ObjectInputStream(input);
        try {
            LegReferenceType type = LegReferenceSerializer.readEnum(in, LegReferenceType.class);
            legReference2 = type.getDeserializer().read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.warn("Unable to decode leg reference (incompatible serialization format): '{}'", (Object)legReference, (Object)e);
                return null;
            }
        }
        in.close();
        return legReference2;
    }

    static void writeScheduledTransitLegV1(LegReference ref, ObjectOutputStream out) throws IOException {
        if (!(ref instanceof ScheduledTransitLegReference)) {
            throw new IllegalArgumentException("Invalid LegReference type");
        }
        ScheduledTransitLegReference s = (ScheduledTransitLegReference)ref;
        out.writeUTF(s.tripId().toString());
        out.writeUTF(s.serviceDate().toString());
        out.writeInt(s.fromStopPositionInPattern());
        out.writeInt(s.toStopPositionInPattern());
    }

    static void writeScheduledTransitLegV2(LegReference ref, ObjectOutputStream out) throws IOException {
        if (!(ref instanceof ScheduledTransitLegReference)) {
            throw new IllegalArgumentException("Invalid LegReference type");
        }
        ScheduledTransitLegReference s = (ScheduledTransitLegReference)ref;
        out.writeUTF(s.tripId().toString());
        out.writeUTF(s.serviceDate().toString());
        out.writeInt(s.fromStopPositionInPattern());
        out.writeInt(s.toStopPositionInPattern());
        out.writeUTF(s.fromStopId().toString());
        out.writeUTF(s.toStopId().toString());
    }

    static void writeScheduledTransitLegV3(LegReference ref, ObjectOutputStream out) throws IOException {
        if (!(ref instanceof ScheduledTransitLegReference)) {
            throw new IllegalArgumentException("Invalid LegReference type");
        }
        ScheduledTransitLegReference s = (ScheduledTransitLegReference)ref;
        out.writeUTF(s.tripOnServiceDateId() == null ? s.tripId().toString() : "");
        out.writeUTF(s.serviceDate().toString());
        out.writeInt(s.fromStopPositionInPattern());
        out.writeInt(s.toStopPositionInPattern());
        out.writeUTF(s.fromStopId().toString());
        out.writeUTF(s.toStopId().toString());
        out.writeUTF(s.tripOnServiceDateId() == null ? "" : s.tripOnServiceDateId().toString());
    }

    static LegReference readScheduledTransitLegV1(ObjectInputStream objectInputStream) throws IOException {
        return new ScheduledTransitLegReference(FeedScopedId.parse(objectInputStream.readUTF()), LocalDate.parse(objectInputStream.readUTF(), DateTimeFormatter.ISO_LOCAL_DATE), objectInputStream.readInt(), objectInputStream.readInt(), null, null, null);
    }

    static LegReference readScheduledTransitLegV2(ObjectInputStream objectInputStream) throws IOException {
        return new ScheduledTransitLegReference(FeedScopedId.parse(objectInputStream.readUTF()), LocalDate.parse(objectInputStream.readUTF(), DateTimeFormatter.ISO_LOCAL_DATE), objectInputStream.readInt(), objectInputStream.readInt(), FeedScopedId.parse(objectInputStream.readUTF()), FeedScopedId.parse(objectInputStream.readUTF()), null);
    }

    static LegReference readScheduledTransitLegV3(ObjectInputStream objectInputStream) throws IOException {
        return new ScheduledTransitLegReference(FeedScopedId.parse(objectInputStream.readUTF()), LocalDate.parse(objectInputStream.readUTF(), DateTimeFormatter.ISO_LOCAL_DATE), objectInputStream.readInt(), objectInputStream.readInt(), FeedScopedId.parse(objectInputStream.readUTF()), FeedScopedId.parse(objectInputStream.readUTF()), FeedScopedId.parse(objectInputStream.readUTF()));
    }

    private static <T extends Enum<T>> void writeEnum(T value, ObjectOutputStream out) throws IOException {
        out.writeUTF(value.name());
    }

    private static <T extends Enum<T>> T readEnum(ObjectInputStream in, Class<T> enumType) throws IOException {
        String value = in.readUTF();
        return Enum.valueOf(enumType, value);
    }
}

